/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.base.domain.ref;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import org.hibernate.annotations.GenericGenerator;
import org.jresearch.commons.base.domain.DomainJpa;
import org.jresearch.commons.base.domain.IAdminObject;
import org.jresearch.commons.base.domain.ref.MultipleProperty;

@Entity
public class SystemProperty
extends DomainJpa
implements IAdminObject {
    @Id
    @GenericGenerator(name="increment", strategy="increment")
    @GeneratedValue(generator="increment")
    @Column(insertable=false, updatable=false)
    private Long id;
    @Column(unique=true, nullable=false)
    private String name;
    private String value;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="multiple_property", joinColumns={@JoinColumn(name="property_id")})
    @OrderColumn(name="value_number")
    private List<MultipleProperty> multipleProperties = new ArrayList<MultipleProperty>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<MultipleProperty> getMultipleProperties() {
        return this.multipleProperties;
    }

    public void setMultipleProperties(List<MultipleProperty> multipleProperties) {
        this.multipleProperties = multipleProperties;
    }

    public void addMultipleProperty(String s) {
        MultipleProperty mp = new MultipleProperty();
        mp.setValue(s);
        this.multipleProperties.add(mp);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("super", (Object)super.toString()).add("id", (Object)this.id).add("name", (Object)this.name).add("value", (Object)this.value).add("multipleProperties", this.multipleProperties).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getId(), this.getName(), this.getValue(), this.getMultipleProperties()});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SystemProperty) {
            if (!super.equals(object)) {
                return false;
            }
            SystemProperty that = (SystemProperty)object;
            return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getValue(), (Object)that.getValue()) && Objects.equal(this.getMultipleProperties(), that.getMultipleProperties());
        }
        return false;
    }
}

