/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.base.date;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public final class BaseDates {
    private BaseDates() {
    }

    public static org.joda.time.LocalDate localJavaJodaDate(@Nonnull LocalDate date) {
        return new org.joda.time.LocalDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static LocalDate localJodaJavaDate(@Nonnull org.joda.time.LocalDate date) {
        return LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    public static LocalDateTime localJavaJodaDateTime(@Nonnull LocalDate date, int hour, int minute) {
        return new LocalDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), hour, minute);
    }

    public static LocalTime localJavaJodaTime(@Nonnull java.time.LocalTime time) {
        return new LocalTime(time.getHour(), time.getMinute(), time.getSecond());
    }

    public static java.time.LocalTime localJodaJavaTime(@Nonnull LocalTime time) {
        return java.time.LocalTime.of(time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute());
    }

    public static DateTime javaJodaDateTime(@Nonnull LocalDate date, @Nonnull ZoneId zone) {
        return BaseDates.localJavaJodaDate(date).toDateTimeAtStartOfDay(BaseDates.javaJodaTimeZone(zone));
    }

    public static ZonedDateTime jodaJavaDateTime(@Nonnull DateTime dateTime) {
        return ZonedDateTime.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute(), 0, ZoneId.of(dateTime.getZone().getID()));
    }

    public static DateTimeZone javaJodaTimeZone(@Nonnull ZoneId zone) {
        return DateTimeZone.forID((String)zone.getId());
    }
}

