/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.base.domain;

import com.google.common.base.MoreObjects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.jresearch.commons.base.domain.DomainJpa;
import org.jresearch.commons.base.domain.User;

@Entity
public class VerificationToken
extends DomainJpa {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="token_generator")
    @SequenceGenerator(name="token_generator", sequenceName="token_seq")
    private Long id;
    @Column(nullable=false, unique=true)
    private String token;
    @Column(name="CREATED_DATE")
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentLocalDateTime")
    private LocalDateTime creationDate;
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentLocalDateTime")
    private LocalDateTime expirationDate;
    private boolean multiple;
    @ManyToOne
    @JoinColumn(name="NET_USER")
    private User user;

    public LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(LocalDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean expired() {
        return new LocalDateTime().isAfter((ReadablePartial)this.expirationDate);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("super", (Object)super.toString()).add("id", (Object)this.id).add("token", (Object)this.token).add("creationDate", (Object)this.creationDate).add("expirationDate", (Object)this.expirationDate).add("multiple", this.multiple).add("user", (Object)VerificationToken.id(this.user)).toString();
    }
}

