/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.flexess.datacreator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractBeanApplicationListener<E extends ApplicationEvent>
implements ApplicationListener<E> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final List<E> deferedEvents = new ArrayList();

    public void init() {
        this.logger.debug("Initializing application listener bean");
        this.listenerBeanInit();
        this.inited.set(true);
        for (ApplicationEvent event : this.deferedEvents) {
            this.processEvent(event);
        }
    }

    protected void listenerBeanInit() {
    }

    public void onApplicationEvent(E event) {
        if (this.inited.get()) {
            this.processEvent(event);
        } else {
            this.logger.debug("Server data creator bean isn't initialized yet. Add event to defered queue");
            this.deferedEvents.add(event);
        }
    }

    protected abstract void processEvent(E var1);
}

