DROP TABLE IF EXISTS permission_parameter;
DROP TABLE IF EXISTS permission_role;
DROP TABLE IF EXISTS dynamic_role;
DROP TABLE IF EXISTS application;
DROP TABLE IF EXISTS model;
DROP TABLE IF EXISTS permission_instance;
DROP TABLE IF EXISTS permission_role;
DROP TABLE IF EXISTS role_instance;

CREATE TABLE IF NOT EXISTS user_role (
		user_role_id character varying(255) NOT NULL,
		userid character varying(255) NOT NULL,
		roleid character varying(255),
		PRIMARY KEY (user_role_id)
);

CREATE TABLE IF NOT EXISTS umi_settings (
		settings_id character varying(255) NOT NULL,
		providerid character varying(255) NOT NULL,
		name character varying(255) NOT NULL,
		description character varying(255),
		PRIMARY KEY (settings_id)
);

CREATE TABLE IF NOT EXISTS umi_settings_group_field (
		id bigint NOT NULL,
		name character varying(255) NOT NULL,
		settings_id character varying(255),
		PRIMARY KEY (id),
		FOREIGN KEY (settings_id) REFERENCES umi_settings(settings_id)
);

CREATE TABLE IF NOT EXISTS umi_settings_field (
		id bigint NOT NULL,
		name character varying(255) NOT NULL,
		value character varying(2560),
		group_id bigint,
		PRIMARY KEY (id),
		FOREIGN KEY (group_id) REFERENCES umi_settings_group_field(id)
);

