/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.flexess.aop;

import java.text.MessageFormat;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jresearch.commons.base.manager.api.IUserManager;
import org.jresearch.commons.base.manager.api.obj.IUser;
import org.jresearch.commons.flexess.aop.Runas;
import org.jresearch.flexess.client.IAuthorizationManager;
import org.jresearch.flexess.client.context.IUserContext;
import org.jresearch.flexess.client.context.UserContextManager;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class AutoUserAspect {
    @Autowired
    private IUserManager userManager;
    @Autowired
    private IAuthorizationManager authorizationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(public * *(..)) && @annotation(context)")
    public Object updateUserContext(ProceedingJoinPoint pjp, Runas context) throws Throwable {
        IUserContext currentContext = UserContextManager.getContext();
        try {
            String name = context.userName();
            IUser user = this.userManager.findUser(name);
            if (user == null) {
                throw new IllegalStateException(MessageFormat.format("Unable to find the user for the context {0} ", name));
            }
            this.authorizationManager.initUserContext(String.valueOf(user.getId()));
            Object object = pjp.proceed();
            return object;
        }
        finally {
            UserContextManager.setContext((IUserContext)currentContext);
        }
    }
}

