/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.flexess.aop;

import java.text.MessageFormat;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.jresearch.commons.base.manager.api.IUserManager;
import org.jresearch.commons.base.manager.api.obj.IUser;
import org.jresearch.commons.flexess.aop.Runas;
import org.jresearch.flexess.client.IAuthorizationManager;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class AutoUserAspect {
    @Autowired
    private IUserManager userManager;
    @Autowired
    private IAuthorizationManager authorizationManager;

    @Before(value="execution(public * *(..)) && @annotation(context)")
    public void updateUserContext(Runas context) {
        String name = context.userName();
        IUser user = this.userManager.findUser(name);
        if (user == null) {
            throw new IllegalStateException(MessageFormat.format("Unable to find the user for the context {0} ", name));
        }
        this.authorizationManager.initUserContext(user.getId().toString());
    }
}

