/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.flexess.role.dao;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jresearch.commons.flexess.role.model.UserRole;
import org.jresearch.flexess.core.model.IUserRole;
import org.springframework.stereotype.Repository;

@Repository
public class RoleUserDao {
    public static final String USER_ROLE_ALL = "UserRole.all";
    public static final String USER_ROLE_FIND_BY_ROLE = "UserRole.findByRole";
    public static final String USER_ROLE_FIND_BY_USER = "UserRole.findByUser";
    public static final String USER_ROLE_FIND = "UserRole.find";
    @PersistenceContext
    protected EntityManager em;

    public void addUserRole(IUserRole role) {
        this.em.merge((Object)RoleUserDao.transform(role));
    }

    private static UserRole transform(IUserRole role) {
        if (role instanceof UserRole) {
            return (UserRole)role;
        }
        UserRole result = new UserRole();
        result.setRoleId(role.getRoleId());
        result.setUserId(role.getUserId());
        return result;
    }

    @Nonnull
    public Optional<IUserRole> findRole(@Nonnull String userId, @Nonnull String roleId) {
        List list = this.em.createNamedQuery(USER_ROLE_FIND, IUserRole.class).setParameter("userId", (Object)userId).setParameter("roleId", (Object)roleId).getResultList();
        return list.stream().findAny();
    }

    public void removeUserRole(String userId, String roleId) {
        this.findRole(userId, roleId).ifPresent(arg_0 -> ((EntityManager)this.em).remove(arg_0));
    }

    @Nonnull
    public List<IUserRole> getRolesByUser(String userId) {
        return this.em.createNamedQuery(USER_ROLE_FIND_BY_USER, IUserRole.class).setParameter("userId", (Object)userId).getResultList();
    }

    @Nonnull
    public List<IUserRole> getAll() {
        return this.em.createNamedQuery(USER_ROLE_ALL, IUserRole.class).getResultList();
    }

    @Nonnull
    public List<IUserRole> getUsersByRole(String roleId) {
        return this.em.createNamedQuery(USER_ROLE_FIND_BY_ROLE, IUserRole.class).setParameter("roleId", (Object)roleId).getResultList();
    }
}

