/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.flexess.datacreator;

import javax.annotation.Nonnull;
import org.jresearch.commons.flexess.datacreator.AbstractBeanApplicationListener;
import org.jresearch.flexess.client.IAuthorizationManager;
import org.jresearch.flexess.core.event.DeployedModelEvent;
import org.jresearch.flexess.core.event.ModelEvent;
import org.jresearch.flexess.core.event.ModelsLoadedEvent;
import org.jresearch.flexess.core.model.IRoleMetaInfo;
import org.jresearch.flexess.core.model.ObjectNotFoundException;
import org.jresearch.flexess.core.services.IRoleService;
import org.jresearch.flexess.core.services.IUserRolesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractServerDataCreator
extends AbstractBeanApplicationListener<ModelEvent> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String adminRoleId;
    private String adminUserName;
    private String systemRoleId;
    private String systemUserName;
    @Autowired
    @Qualifier(value="flexess_core_roleService")
    private IRoleService roleService;
    @Autowired
    @Qualifier(value="flexess_core_userRoles")
    private IUserRolesService userRolesService;
    private String defaultRole;
    @Autowired
    private IAuthorizationManager authorizationManager;
    private String adminUserId;
    private String systemUserId;

    public void createApplicationData() {
    }

    @Override
    protected void listenerBeanInit() {
        this.LOGGER.debug("Initializing Flexess data creator bean");
        this.LOGGER.debug("Create user {}", (Object)this.adminUserName);
        if (this.adminUserName != null) {
            this.adminUserId = this.createUserIfNecessary(this.adminUserName);
        }
        this.LOGGER.debug("Create user {}", (Object)this.systemUserName);
        if (this.systemUserName != null) {
            this.systemUserId = this.createUserIfNecessary(this.systemUserName);
        }
        if (this.defaultRole != null) {
            this.authorizationManager.setDefaultRole(this.defaultRole);
        }
    }

    @Nonnull
    protected abstract String createUserIfNecessary(@Nonnull String var1);

    @Override
    protected void processEvent(ModelEvent event) {
        this.LOGGER.debug("Process event {}", (Object)event);
        if (event instanceof DeployedModelEvent) {
            this.processDeployEvent((DeployedModelEvent)event);
        } else if (event instanceof ModelsLoadedEvent) {
            this.processLoadedEvent();
        }
    }

    protected void processDeployEvent(DeployedModelEvent event) {
        String modelId = event.getModelId();
        if (modelId != null) {
            if (this.adminUserId != null && this.adminRoleId != null) {
                this.updateRoles(modelId, this.adminUserId, this.adminRoleId);
            }
            if (this.systemUserId != null && this.systemRoleId != null) {
                this.updateRoles(modelId, this.systemUserId, this.systemRoleId);
            }
            this.updateRoles(modelId, "kyZByGQj#^8XXY$kP8cHpKtFupk&gRQRHr!f@dGNHKjGDNWXaZ", "anonymous");
        }
    }

    protected void processLoadedEvent() {
        this.createApplicationData();
    }

    public void updateRoles(@Nonnull String modelId, @Nonnull String userId, @Nonnull String roleId) {
        try {
            this.roleService.getRole(modelId, roleId).filter(r -> this.isUserHasNotRole(userId, (IRoleMetaInfo)r)).ifPresent(r -> this.userRolesService.addUserRole(userId, r));
        }
        catch (ObjectNotFoundException e) {
            this.LOGGER.error("Can't update a role {} in the model {} for the user {}: {}", new Object[]{roleId, modelId, userId, e.getLocalizedMessage(), e});
        }
    }

    private boolean isUserHasNotRole(String userId, IRoleMetaInfo role) {
        return !this.userRolesService.getUserIds(role).contains(userId);
    }

    @Required
    public void setAdminRoleId(String adminRoleId) {
        this.adminRoleId = adminRoleId;
    }

    @Required
    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    @Required
    public void setSystemRoleId(String systemRoleId) {
        this.systemRoleId = systemRoleId;
    }

    @Required
    public void setSystemUserName(String systemUserName) {
        this.systemUserName = systemUserName;
    }

    @Required
    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }
}

