/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.app.server.service.user;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jresearch.commons.base.domain.filters.QueryResponse;
import org.jresearch.commons.base.domain.filters.UserFilter;
import org.jresearch.commons.base.mail.IMailService;
import org.jresearch.commons.base.manager.api.IBusinessTypeManager;
import org.jresearch.commons.base.manager.api.IMailTemplateManager;
import org.jresearch.commons.base.manager.api.IUserManager;
import org.jresearch.commons.base.manager.api.IUserProfileManager;
import org.jresearch.commons.base.manager.api.IVerificationTokenManager;
import org.jresearch.commons.base.manager.api.ProfileValidationException;
import org.jresearch.commons.base.manager.api.UserUpdateException;
import org.jresearch.commons.base.manager.api.obj.IUser;
import org.jresearch.commons.base.manager.api.obj.IUserProfile;
import org.jresearch.commons.flexess.umi.BaseUmiUserManager;
import org.jresearch.commons.gwt.app.server.service.user.ILocalUserService;
import org.jresearch.commons.gwt.app.shared.model.user.ProfileValidationModelException;
import org.jresearch.commons.gwt.app.shared.model.user.UserModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserRegistrationModelException;
import org.jresearch.commons.gwt.app.shared.service.user.AbstractUserService;
import org.jresearch.commons.gwt.server.service.AbstractDomainServiceImpl;
import org.jresearch.commons.gwt.server.service.localization.ILocaleChangeListener;
import org.jresearch.commons.gwt.server.service.localization.LocalizationService;
import org.jresearch.commons.gwt.shared.loader.CrudLoadConfig;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;
import org.jresearch.commons.gwt.shared.service.AccessDenidedException;
import org.jresearch.commons.gwt.shared.service.AnonymousUserException;
import org.jresearch.commons.gwt.shared.service.NoUserException;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.client.context.IUserContext;
import org.jresearch.flexess.client.context.UserContextManager;
import org.jresearch.flexess.umi.api.UnsupportedAuthenticationMethodException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractUserServiceImpl<U extends UserModel>
extends AbstractDomainServiceImpl
implements AbstractUserService<U>,
ILocaleChangeListener,
ILocalUserService {
    @Autowired
    protected IUserManager manager;
    protected IUserProfileManager profileManager;
    private IBusinessTypeManager businessTypeManager;
    private BaseUmiUserManager umiManager;
    private IMailService mailService;
    private IMailTemplateManager mailTemplateManager;
    private LocalizationService localizationService;
    @Autowired
    private IVerificationTokenManager verificationTokenManager;

    @Override
    public long getCurrentUserId() throws NoUserException, AnonymousUserException {
        try {
            String userId = UserContextManager.getContext().getUserId();
            if (userId == null) {
                throw new NoUserException("No user in context on server side");
            }
            if ("kyZByGQj#^8XXY$kP8cHpKtFupk&gRQRHr!f@dGNHKjGDNWXaZ".equals(userId)) {
                throw new AnonymousUserException("No real user in context on server side");
            }
            return Long.parseLong(userId);
        }
        catch (NumberFormatException | UamClientException e) {
            throw new NoUserException("No user in context on server side", e);
        }
    }

    @Nonnull
    public U getCurrentUser() throws NoUserException {
        try {
            return this.get(this.getCurrentUserId());
        }
        catch (UamClientException e) {
            throw new NoUserException("No user in context on server side", (Throwable)e);
        }
    }

    @Nonnull
    protected U get(long id) throws NoUserException {
        IUser user = this.manager.getUser(id);
        if (user == null) {
            throw new NoUserException("No user in context on server side");
        }
        U result = this.toUser(user);
        if (result == null) {
            throw new NoUserException("Server side user can't be mapped to client side");
        }
        result.setUserProfile((UserProfileModel)this.adapter.map((Object)this.profileManager.getUserProfile(user.getId()), UserProfileModel.class));
        return result;
    }

    public List<U> getAll(CrudLoadConfig<U> config) {
        UserFilter filter = this.createFilter(config);
        QueryResponse users = this.manager.searchUsers(filter);
        List<U> result = this.toUserList(users.getRecords());
        for (UserModel user : result) {
            user.setUserProfile((UserProfileModel)this.adapter.map((Object)this.profileManager.getUserProfile((Long)user.getId()), UserProfileModel.class));
        }
        return result;
    }

    protected abstract List<U> toUserList(@Nonnull List<IUser> var1);

    protected abstract U toUser(IUser var1);

    protected abstract IUser fromUser(U var1);

    private UserFilter createFilter(CrudLoadConfig<U> config) {
        UserFilter result = new UserFilter();
        result.setFirstPosition(0);
        result.setPageSize(1000);
        return result;
    }

    public void remove(Collection<U> models) {
        for (UserModel model : models) {
            this.manager.removeUser((Long)model.getId());
        }
    }

    public void update(U model) throws UserRegistrationModelException {
        try {
            this.manager.saveUser(this.fromUser(model));
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    public U create(U prototype) throws UserRegistrationModelException {
        try {
            String userName = prototype.getUserName();
            String email = prototype.getEmail();
            assert (userName != null && email != null);
            IUser user = this.manager.registerUser(userName, email);
            U userModel = this.toUser(user);
            userModel.setUserProfile((UserProfileModel)this.adapter.map((Object)this.profileManager.getUserProfile(user.getId()), UserProfileModel.class));
            return userModel;
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    @Override
    public UserProfileModel getCurrentUserProfile() {
        return (UserProfileModel)this.adapter.map((Object)this.getCurrentUserProfileRaw(), UserProfileModel.class);
    }

    protected IUserProfile getCurrentUserProfileRaw() {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            return null;
        }
        IUserProfile profile = (IUserProfile)context.getUserObject("jrs_UserService_USER_PROFILE");
        if (profile == null) {
            try {
                IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
                if (user != null) {
                    profile = this.profileManager.getUserProfile(user.getId());
                    context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
                }
            }
            catch (NumberFormatException e) {
                profile = this.profileManager.getDefaultUserProfile();
                context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
            }
        }
        return profile;
    }

    protected IUserProfile updateProfileInContext(IUserProfile profile) {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context != null) {
            context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
        }
        return profile;
    }

    private static IUserContext getUserContext() {
        return UserContextManager.getContext();
    }

    public List<BusinessTypeModel> getProfileTypes() {
        List businessTypes = this.businessTypeManager.getUserBusinessTypes();
        return this.adapter.mapAsList((Iterable)businessTypes, BusinessTypeModel.class);
    }

    public void changePassword(String newPassword) throws AccessDenidedException {
        this.changePassword(null, newPassword);
    }

    public void changePassword(@Nullable String oldPassword, String newPassword) throws AccessDenidedException {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            throw new AccessDenidedException("Wrong user context");
        }
        try {
            IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
            if (user == null || user.getId() == null) {
                throw new AccessDenidedException("User is not found");
            }
            if (oldPassword != null && !this.umiManager.checkPassword(user, oldPassword)) {
                throw new AccessDenidedException("Password is wrong");
            }
            this.umiManager.changeUserPassword(user.getId(), newPassword);
            this.verificationTokenManager.removeToken(user.getId().longValue());
            String subject = "Password changed";
            String content = "You password was changed";
            this.mailService.sendMessage(user.getEmail(), "Password changed", "You password was changed");
        }
        catch (NumberFormatException e) {
            throw new AccessDenidedException((Throwable)e);
        }
        catch (UnsupportedAuthenticationMethodException e) {
            throw new AccessDenidedException((Throwable)e);
        }
    }

    public UserProfileModel updateProfile(UserProfileModel profile) throws ProfileValidationModelException, UserRegistrationModelException {
        return (UserProfileModel)this.adapter.map((Object)this.updateProfileRaw(profile), UserProfileModel.class);
    }

    protected IUserProfile updateProfileRaw(UserProfileModel profile) throws ProfileValidationModelException, UserRegistrationModelException {
        try {
            this.manager.saveUser((IUser)this.adapter.map((Object)profile.getUser(), IUser.class));
            return this.updateProfileInContext(this.profileManager.saveUserProfile((IUserProfile)this.adapter.map((Object)profile, IUserProfile.class)));
        }
        catch (ProfileValidationException e) {
            throw (ProfileValidationModelException)this.adapter.map((Object)e, ProfileValidationModelException.class);
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    public void removeUser() throws AccessDenidedException {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            throw new AccessDenidedException("Unknown user");
        }
        try {
            IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
            this.manager.removeUser(user.getId());
            String subject = "User remove";
            String content = "You account was removed";
            this.mailService.sendMessage(user.getEmail(), "User remove", "You account was removed");
        }
        catch (NumberFormatException e) {
            throw new AccessDenidedException("Unknown user");
        }
    }

    @Required
    public void setBusinessTypeManager(IBusinessTypeManager businessTypeManager) {
        this.businessTypeManager = businessTypeManager;
    }

    @Required
    public void setProfileManager(IUserProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    @Required
    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public void setLocale(Locale locale) {
        UserProfileModel profile = this.getCurrentUserProfile();
        if (profile.getUser() != null) {
            profile.getUserSettings().setLocale((LocaleModel)this.adapter.map((Object)locale, LocaleModel.class));
            this.updateProfile(profile);
        }
    }

    protected void init() {
        this.localizationService.addListener((ILocaleChangeListener)this);
    }

    @Required
    public void setMailService(IMailService mailService) {
        this.mailService = mailService;
    }

    @Required
    public void setUmiManager(BaseUmiUserManager umiManager) {
        this.umiManager = umiManager;
    }
}

