/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.app.server.service.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jresearch.commons.base.manager.api.IMailTemplateManager;
import org.jresearch.commons.base.manager.api.ISystemEventManager;
import org.jresearch.commons.base.manager.api.obj.IMailTemplate;
import org.jresearch.commons.base.manager.api.obj.ISystemEvent;
import org.jresearch.commons.base.manager.impl.dto.MailTemplateDto;
import org.jresearch.commons.base.manager.impl.dto.ref.SystemEventDto;
import org.jresearch.commons.gwt.app.shared.model.user.MailTemplateModel;
import org.jresearch.commons.gwt.app.shared.model.user.SystemEventModel;
import org.jresearch.commons.gwt.app.shared.service.mail.MailTemplateService;
import org.jresearch.commons.gwt.server.service.AbstractDomainServiceImpl;
import org.jresearch.commons.gwt.shared.loader.CrudLoadConfig;
import org.springframework.beans.factory.annotation.Required;

public class MailTemplateServiceImpl
extends AbstractDomainServiceImpl
implements MailTemplateService {
    private IMailTemplateManager manager;
    private ISystemEventManager eventManager;

    public List<MailTemplateModel> getAll() {
        List t = this.manager.getMailTemplates();
        ArrayList<MailTemplateModel> temps = new ArrayList<MailTemplateModel>();
        for (IMailTemplate iMailTemplate : t) {
            MailTemplateModel mt = new MailTemplateModel();
            mt.setId((Object)iMailTemplate.getId());
            mt.setSubject(iMailTemplate.getSubject());
            mt.setTemplate(iMailTemplate.getSubject());
            SystemEventModel sm = new SystemEventModel();
            sm.setCode(iMailTemplate.getSystemEvent().getCode());
            sm.setName(iMailTemplate.getSystemEvent().getName(Locale.ENGLISH));
            mt.setEvent(sm);
            temps.add(mt);
        }
        return temps;
    }

    public MailTemplateModel create(MailTemplateModel prototype) {
        MailTemplateDto dto = new MailTemplateDto();
        dto.setSubject(prototype.getSubject());
        dto.setTemplate(prototype.getTemplate());
        SystemEventDto se = new SystemEventDto();
        se.setCode(prototype.getEvent().getCode());
        dto.setSystemEvent((ISystemEvent)se);
        IMailTemplate newTemp = this.manager.saveTemplate((IMailTemplate)dto);
        prototype.setId((Object)newTemp.getId());
        return prototype;
    }

    public void remove(Collection<MailTemplateModel> models) {
        for (MailTemplateModel model : models) {
            this.manager.removeMailTemplate((Long)model.getId());
        }
    }

    public void update(MailTemplateModel model) {
        this.manager.saveTemplate((IMailTemplate)this.adapter.map((Object)model, IMailTemplate.class));
    }

    @Required
    public void setManager(IMailTemplateManager manager) {
        this.manager = manager;
    }

    @Required
    public void setEventManager(ISystemEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public List<MailTemplateModel> getAll(CrudLoadConfig<MailTemplateModel> config) {
        return this.getAll();
    }

    public List<SystemEventModel> getEvents() {
        List events = this.eventManager.getSystemEvents();
        ArrayList<SystemEventModel> gwtEvents = new ArrayList<SystemEventModel>(events.size());
        for (ISystemEvent event : events) {
            gwtEvents.add((SystemEventModel)this.adapter.map((Object)event, SystemEventModel.class));
        }
        return gwtEvents;
    }
}

