/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.app.server.service.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import one.util.streamex.StreamEx;
import org.jresearch.commons.base.manager.api.IMailTemplateManager;
import org.jresearch.commons.base.manager.api.ISystemEventManager;
import org.jresearch.commons.base.manager.api.obj.IMailTemplate;
import org.jresearch.commons.base.manager.api.obj.ISystemEvent;
import org.jresearch.commons.base.manager.impl.dto.MailTemplateDto;
import org.jresearch.commons.base.manager.impl.dto.ref.SystemEventDto;
import org.jresearch.commons.gwt.app.shared.model.user.MailTemplateModel;
import org.jresearch.commons.gwt.app.shared.model.user.SystemEventModel;
import org.jresearch.commons.gwt.app.shared.service.mail.MailTemplateService;
import org.jresearch.commons.gwt.server.rest.AbstractDomainControler;
import org.jresearch.commons.gwt.shared.loader.PageCrudLoadConfig;
import org.jresearch.commons.gwt.shared.loader.PageLoadResult;
import org.jresearch.commons.gwt.shared.loader.PageLoadResultBean;
import org.jresearch.commons.gwt.shared.model.DomainNewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MailTemplateServiceImpl
extends AbstractDomainControler<MailTemplateModel>
implements MailTemplateService {
    @Autowired
    private IMailTemplateManager manager;
    @Autowired
    private ISystemEventManager eventManager;

    @RequestMapping(value={"/MailTemplateService/r"}, method={RequestMethod.POST})
    public PageLoadResult<MailTemplateModel> getAll(PageCrudLoadConfig<MailTemplateModel> config) {
        return new PageLoadResultBean(this.getAll());
    }

    @RequestMapping(value={"/MailTemplateService/getAll"}, method={RequestMethod.GET})
    public List<MailTemplateModel> getAll() {
        List t = this.manager.getMailTemplates();
        ArrayList<MailTemplateModel> temps = new ArrayList<MailTemplateModel>();
        for (IMailTemplate iMailTemplate : t) {
            MailTemplateModel mt = new MailTemplateModel();
            mt.setId((Object)iMailTemplate.getId());
            mt.setSubject(iMailTemplate.getSubject());
            mt.setTemplate(iMailTemplate.getSubject());
            SystemEventModel sm = new SystemEventModel();
            sm.setCode(iMailTemplate.getSystemEvent().getCode());
            sm.setName(iMailTemplate.getSystemEvent().getName(Locale.ENGLISH));
            mt.setEvent(sm);
            temps.add(mt);
        }
        return temps;
    }

    @RequestMapping(value={"/MailTemplateService/c"}, method={RequestMethod.PUT})
    public MailTemplateModel create(MailTemplateModel prototype) {
        MailTemplateDto dto = new MailTemplateDto();
        dto.setSubject(prototype.getSubject());
        dto.setTemplate(prototype.getTemplate());
        SystemEventDto se = new SystemEventDto();
        se.setCode(prototype.getEvent().getCode());
        dto.setSystemEvent((ISystemEvent)se);
        IMailTemplate newTemp = this.manager.saveTemplate((IMailTemplate)dto);
        prototype.setId((Object)newTemp.getId());
        return prototype;
    }

    @RequestMapping(value={"/MailTemplateService/d"}, method={RequestMethod.DELETE})
    public void remove(Collection<MailTemplateModel> models) {
        this.remove(models, DomainNewModel::getId, arg_0 -> ((IMailTemplateManager)this.manager).removeMailTemplate(arg_0));
    }

    @RequestMapping(value={"/MailTemplateService/u"}, method={RequestMethod.POST})
    public void update(MailTemplateModel model) {
        this.manager.saveTemplate((IMailTemplate)this.adapter.map((Object)model, IMailTemplate.class));
    }

    @RequestMapping(value={"/MailTemplateService/getEvents"}, method={RequestMethod.GET})
    public List<SystemEventModel> getEvents() {
        return StreamEx.of((Collection)this.eventManager.getSystemEvents()).map(e -> (SystemEventModel)this.adapter.map(e, SystemEventModel.class)).toList();
    }
}

