/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.app.server.service.user;

import java.util.List;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.jresearch.commons.base.manager.api.obj.IUser;
import org.jresearch.commons.flexess.service.GwtFlexessUtils;
import org.jresearch.commons.gwt.app.server.service.user.AbstractUserServiceImpl;
import org.jresearch.commons.gwt.app.shared.model.user.UserExtModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserRegistrationModelException;
import org.jresearch.commons.gwt.app.shared.service.user.UserExtService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/UserExtService"})
public class UserExtServiceImpl
extends AbstractUserServiceImpl<UserExtModel>
implements UserExtService {
    @Autowired
    private GwtFlexessUtils adminFlexessUtils;

    @Override
    protected List<UserExtModel> toUserList(@Nonnull List<IUser> users) {
        return ((StreamEx)StreamEx.of(users).parallel(this.adapter.getPool())).map(this::toUser).toList();
    }

    @Override
    protected UserExtModel toUser(IUser user) {
        UserExtModel result = (UserExtModel)this.adapter.map((Object)user, UserExtModel.class);
        result.setRoles(this.adminFlexessUtils.getGwtUserRoles(user.getId().toString()));
        return result;
    }

    @Override
    public void update(UserExtModel model) throws UserRegistrationModelException {
        super.update(model);
        this.adminFlexessUtils.updateRoles(((Long)model.getId()).toString(), model.getRoles());
    }

    @Override
    public UserExtModel create(UserExtModel prototype) throws UserRegistrationModelException {
        UserExtModel result = super.create(prototype);
        this.adminFlexessUtils.updateRoles(((Long)result.getId()).toString(), prototype.getRoles());
        return result;
    }

    @Override
    protected IUser fromUser(UserExtModel user) {
        return (IUser)this.adapter.map((Object)user, IUser.class);
    }
}

