/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.app.server.service.user;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jresearch.commons.base.domain.filters.QueryResponse;
import org.jresearch.commons.base.domain.filters.UserFilter;
import org.jresearch.commons.base.mail.IMailService;
import org.jresearch.commons.base.manager.api.IBusinessTypeManager;
import org.jresearch.commons.base.manager.api.IMailTemplateManager;
import org.jresearch.commons.base.manager.api.IUserManager;
import org.jresearch.commons.base.manager.api.IUserProfileManager;
import org.jresearch.commons.base.manager.api.IVerificationTokenManager;
import org.jresearch.commons.base.manager.api.ProfileValidationException;
import org.jresearch.commons.base.manager.api.UserUpdateException;
import org.jresearch.commons.base.manager.api.obj.IUser;
import org.jresearch.commons.base.manager.api.obj.IUserProfile;
import org.jresearch.commons.flexess.umi.BaseUmiUserManager;
import org.jresearch.commons.gwt.app.shared.model.user.ProfileValidationModelException;
import org.jresearch.commons.gwt.app.shared.model.user.UserModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserRegistrationModelException;
import org.jresearch.commons.gwt.app.shared.service.user.AbstractUserService;
import org.jresearch.commons.gwt.server.rest.AbstractDomainControler;
import org.jresearch.commons.gwt.shared.loader.PageCrudRestLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.PageLoadResultBean;
import org.jresearch.commons.gwt.shared.model.DomainNewModel;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;
import org.jresearch.commons.gwt.shared.service.AccessDenidedRestException;
import org.jresearch.commons.gwt.shared.service.AnonymousUserException;
import org.jresearch.commons.gwt.shared.service.AnonymousUserRestException;
import org.jresearch.commons.gwt.shared.service.GwtException;
import org.jresearch.commons.gwt.shared.service.NoUserException;
import org.jresearch.commons.gwt.shared.service.NoUserRestException;
import org.jresearch.commons.gwt.shared.service.WrongConfigException;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.client.context.IUserContext;
import org.jresearch.flexess.client.context.UserContextManager;
import org.jresearch.flexess.umi.api.UnsupportedAuthenticationMethodException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class AbstractUserServiceImpl<U extends UserModel>
extends AbstractDomainControler<U>
implements AbstractUserService<U> {
    @Autowired
    protected IUserManager manager;
    @Autowired
    protected IUserProfileManager profileManager;
    @Autowired
    private IBusinessTypeManager businessTypeManager;
    @Autowired
    private BaseUmiUserManager umiManager;
    @Autowired
    private IMailService mailService;
    @Autowired
    private IMailTemplateManager mailTemplateManager;
    @Autowired
    private IVerificationTokenManager verificationTokenManager;

    public long getCurrentUserId() throws NoUserException, AnonymousUserException {
        try {
            String userId = UserContextManager.getContext().getUserId();
            if (userId == null) {
                throw new NoUserException("No user in context on server side");
            }
            if ("kyZByGQj#^8XXY$kP8cHpKtFupk&gRQRHr!f@dGNHKjGDNWXaZ".equals(userId)) {
                throw new AnonymousUserException("No real user in context on server side");
            }
            return Long.parseLong(userId);
        }
        catch (NumberFormatException | UamClientException e) {
            throw new NoUserException("No user in context on server side", e);
        }
    }

    @Nonnull
    @RequestMapping(value={"/getCurrentUser"}, method={RequestMethod.GET})
    public U getCurrentUser() {
        try {
            return this.get(this.getCurrentUserId());
        }
        catch (AnonymousUserException e) {
            throw new AnonymousUserRestException((Throwable)e);
        }
        catch (NoUserException | UamClientException e) {
            throw new NoUserRestException("No user in context on server side", e);
        }
    }

    @Nonnull
    protected U get(long id) throws NoUserException {
        IUser user = this.manager.getUser(id);
        if (user == null) {
            throw new NoUserException("No user in context on server side");
        }
        U result = this.toUser(user);
        this.setUserProfile(result);
        return result;
    }

    @RequestMapping(value={"/r"}, method={RequestMethod.POST})
    public PageLoadResultBean<U> getAll(@RequestBody PageCrudRestLoadConfigBean<U> config) {
        UserFilter filter = this.createFilter(config);
        QueryResponse users = this.manager.searchUsers(filter);
        List<U> result = this.toUserList(users.getRecords());
        result.forEach(this::setUserProfile);
        return new PageLoadResultBean(result);
    }

    private void setUserProfile(U user) {
        long id;
        IUserProfile userProfile;
        if (user != null && user.getId() != null && (userProfile = this.profileManager.getUserProfile(id = ((Long)user.getId()).longValue())) != null) {
            user.setUserProfile((UserProfileModel)this.adapter.map((Object)userProfile, UserProfileModel.class));
        }
    }

    @Nonnull
    protected abstract List<U> toUserList(@Nonnull List<IUser> var1);

    @Nonnull
    protected abstract U toUser(@Nonnull IUser var1);

    @Nonnull
    protected abstract IUser fromUser(@Nonnull U var1);

    @Nonnull
    private UserFilter createFilter(@Nonnull PageCrudRestLoadConfigBean<U> config) {
        UserFilter result = new UserFilter();
        result.setFirstPosition(config.getOffset());
        int amount = config.getAmount();
        result.setPageSize(amount == 0 ? 1000 : amount);
        return result;
    }

    @RequestMapping(value={"/d"}, method={RequestMethod.DELETE})
    public void remove(@RequestBody List<U> models) {
        this.remove(models, DomainNewModel::getId, arg_0 -> ((IUserManager)this.manager).removeUser(arg_0));
    }

    @RequestMapping(value={"/u"}, method={RequestMethod.POST})
    public void update(@RequestBody U model) throws UserRegistrationModelException {
        try {
            this.manager.saveUser(this.fromUser(model));
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    @RequestMapping(value={"/c"}, method={RequestMethod.PUT})
    public U create(@RequestBody U prototype) throws UserRegistrationModelException {
        try {
            String userName = prototype.getUserName();
            String email = prototype.getEmail();
            if (userName == null || email == null) {
                throw new UserRegistrationModelException("User name or email is null");
            }
            IUser user = this.manager.registerUser(userName, email);
            U userModel = this.toUser(user);
            this.setUserProfile(userModel);
            return userModel;
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    @RequestMapping(value={"/getCurrentUserProfile"}, method={RequestMethod.GET})
    public UserProfileModel getCurrentUserProfile() {
        return this.getCurrentUserProfileRaw().map(p -> (UserProfileModel)this.adapter.map(p, UserProfileModel.class)).orElse(null);
    }

    @Nonnull
    protected Optional<IUserProfile> getCurrentUserProfileRaw() {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            return Optional.empty();
        }
        IUserProfile profile = (IUserProfile)context.getUserObject("jrs_UserService_USER_PROFILE");
        if (profile == null) {
            try {
                IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
                if (user != null && user.getId() != null) {
                    profile = this.profileManager.getUserProfile(user.getId().longValue());
                    context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
                }
            }
            catch (NumberFormatException e) {
                profile = this.profileManager.getDefaultUserProfile();
                context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
            }
        }
        return Optional.ofNullable(profile);
    }

    @Nonnull
    protected static IUserProfile updateProfileInContext(@Nonnull IUserProfile profile) {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context != null) {
            context.putUserObject("jrs_UserService_USER_PROFILE", (Object)profile);
        }
        return profile;
    }

    private static IUserContext getUserContext() {
        return UserContextManager.getContext();
    }

    @RequestMapping(value={"/getProfileTypes"}, method={RequestMethod.GET})
    public List<BusinessTypeModel> getProfileTypes() {
        List businessTypes = this.businessTypeManager.getUserBusinessTypes();
        return this.adapter.mapAsList((Iterable)businessTypes, BusinessTypeModel.class);
    }

    @RequestMapping(value={"/changePassword"}, method={RequestMethod.POST})
    public void changePassword(@RequestBody String newPassword) throws AccessDenidedRestException {
        this.changePassword(null, newPassword);
    }

    @RequestMapping(value={"/changePassword/{oldPassword}"}, method={RequestMethod.POST})
    public void changePassword(@PathVariable @Nullable String oldPassword, @RequestBody String newPassword) throws AccessDenidedRestException {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            throw new AccessDenidedRestException("Wrong user context");
        }
        try {
            IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
            if (user == null || user.getId() == null) {
                throw new AccessDenidedRestException("User is not found");
            }
            if (oldPassword != null && !this.umiManager.checkPassword(user, oldPassword)) {
                throw new AccessDenidedRestException("Password is wrong");
            }
            this.umiManager.changeUserPassword(user.getId().longValue(), newPassword);
            this.verificationTokenManager.removeToken(user.getId().longValue());
            String subject = "Password changed";
            String content = "You password was changed";
            this.mailService.sendMessage(user.getEmail(), "Password changed", "You password was changed");
        }
        catch (NumberFormatException e) {
            throw new AccessDenidedRestException((Throwable)e);
        }
        catch (UnsupportedAuthenticationMethodException e) {
            throw new AccessDenidedRestException((Throwable)e);
        }
    }

    @RequestMapping(value={"/updateProfile"}, method={RequestMethod.POST})
    public UserProfileModel updateProfile(@RequestBody UserProfileModel profile) throws ProfileValidationModelException, UserRegistrationModelException {
        return (UserProfileModel)this.adapter.map((Object)this.updateProfileRaw(profile), UserProfileModel.class);
    }

    @Nonnull
    protected IUserProfile updateProfileRaw(@Nonnull UserProfileModel profile) throws ProfileValidationModelException, UserRegistrationModelException {
        try {
            UserModel user = profile.getUser();
            if (user != null) {
                this.manager.saveUser((IUser)this.adapter.map((Object)user, IUser.class));
            }
            return AbstractUserServiceImpl.updateProfileInContext(this.profileManager.saveUserProfile((IUserProfile)this.adapter.map((Object)profile, IUserProfile.class)));
        }
        catch (ProfileValidationException e) {
            throw (ProfileValidationModelException)this.adapter.map((Object)e, ProfileValidationModelException.class);
        }
        catch (UserUpdateException e) {
            throw (UserRegistrationModelException)this.adapter.map((Object)e, UserRegistrationModelException.class);
        }
    }

    @RequestMapping(value={"/removeUser"}, method={RequestMethod.DELETE})
    public void removeUser() throws AccessDenidedRestException {
        IUserContext context = AbstractUserServiceImpl.getUserContext();
        if (context == null) {
            throw new AccessDenidedRestException("Unknown user");
        }
        try {
            IUser user = this.manager.getUser(Long.parseLong(context.getUserId()));
            this.manager.removeUser(user.getId());
            String subject = "User remove";
            String content = "You account was removed";
            this.mailService.sendMessage(user.getEmail(), "User remove", "You account was removed");
        }
        catch (NumberFormatException e) {
            throw new AccessDenidedRestException("Unknown user");
        }
    }

    @ExceptionHandler(value={GwtException.class})
    public ResponseEntity<GwtException> setStatusException(GwtException ex) {
        if (ex instanceof AccessDenidedRestException) {
            return new ResponseEntity((Object)ex, HttpStatus.FORBIDDEN);
        }
        if (ex instanceof AnonymousUserRestException) {
            return ResponseEntity.status((int)600).body((Object)ex);
        }
        if (ex instanceof NoUserRestException) {
            return ResponseEntity.status((int)601).body((Object)ex);
        }
        if (ex instanceof UserRegistrationModelException) {
            return ResponseEntity.status((int)602).body((Object)ex);
        }
        if (ex instanceof WrongConfigException) {
            return ResponseEntity.status((int)603).body((Object)ex);
        }
        return new ResponseEntity((Object)ex, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

