package org.jresearch.commons.gwt.app.client.mvc.widget;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.app.client.UserHolder;
import org.jresearch.commons.gwt.app.client.mvc.FireOnSelect;
import org.jresearch.commons.gwt.app.client.mvc.event.LogoutEvent;
import org.jresearch.commons.gwt.app.client.mvc.event.ProfileShowEvent;
import org.jresearch.commons.gwt.app.client.mvc.event.SignUpEvent;
import org.jresearch.commons.gwt.app.shared.model.user.UserModel;
import org.jresearch.commons.gwt.client.mvc.event.AboutEvent;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.LoginEvent;
import org.jresearch.commons.gwt.client.widget.Uis;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class UserLinkContainer extends HTMLPanel {

    private final UserLink loginLink;
    private final UserLink registrationLink;
    private final UserLink profileLink;
    private final UserLink logoutLink;

    public UserLinkContainer(@Nonnull final UserHolder userHolder, @Nonnull final SafeHtml content, @Nonnull final Bus bus, final UserLink loginLink, final UserLink logoutLink, final UserLink registrationLink, final UserLink profileLink, final Widget aboutLink, final Widget languageSelector) {
        super(content);
        this.loginLink = loginLink;
        this.logoutLink = logoutLink;
        this.registrationLink = registrationLink;
        this.profileLink = profileLink;

        if (loginLink != null) {
            add(this.loginLink.asWidget(), Uis.findByStyle(this, "loginPlaceHolder")); //$NON-NLS-1$
            loginLink.asWidget().addDomHandler(new FireOnSelect(bus, new LoginEvent()), ClickEvent.getType());
        }

        if (logoutLink != null) {
            add(this.logoutLink.asWidget(), Uis.findByStyle(this, "logoutPlaceHolder")); //$NON-NLS-1$
            logoutLink.asWidget().addDomHandler(new FireOnSelect(bus, new LogoutEvent()), ClickEvent.getType());
        }
        if (registrationLink != null) {
            add(this.registrationLink.asWidget(), Uis.findByStyle(this, "registrationPlaceHolder")); //$NON-NLS-1$
            registrationLink.asWidget().addDomHandler(new FireOnSelect(bus, new SignUpEvent()), ClickEvent.getType());
        }
        if (profileLink != null) {
            add(this.profileLink.asWidget(), Uis.findByStyle(this, "profilePlaceHolder")); //$NON-NLS-1$
            profileLink.asWidget().addDomHandler(new ClickHandler() {
                @Override
                public void onClick(final ClickEvent event) {
                    final UserModel user = userHolder.getCurrentUser();
                    if (user != null) {
                        bus.fire(new ProfileShowEvent(user.getUserProfile()));
                    }
                }
            }, ClickEvent.getType());
        }
        if (aboutLink != null) {
            add(aboutLink.asWidget(), Uis.findByStyle(this, "aboutPlaceHolder")); //$NON-NLS-1$
            aboutLink.addDomHandler(new FireOnSelect(bus, new AboutEvent()), ClickEvent.getType());
        }
        if (languageSelector != null) {
            add(languageSelector.asWidget(), Uis.findByStyle(this, "languagePlaceHolder")); //$NON-NLS-1$
        }

        safeDisableUserControl();
    }

    /**
     * Call from constructor
     */
    private void safeDisableUserControl() {
        if (loginLink != null) {
            loginLink.disable();
            loginLink.hide();
        }
        if (logoutLink != null) {
            logoutLink.disable();
            logoutLink.hide();
        }
        if (registrationLink != null) {
            registrationLink.disable();
            registrationLink.hide();
        }
        if (profileLink != null) {
            profileLink.disable();
            profileLink.hide();
        }
    }

    public void disableUserControlAsIs() {
        if (loginLink != null) {
            loginLink.disable();
        }
        if (logoutLink != null) {
            logoutLink.disable();
        }
        if (registrationLink != null) {
            registrationLink.disable();
        }
        if (profileLink != null) {
            profileLink.disable();
        }
    }

    public void enableUserControlAsIs() {
        if (loginLink != null) {
            loginLink.enable();
        }
        if (logoutLink != null) {
            logoutLink.enable();
        }
        if (registrationLink != null) {
            registrationLink.enable();
        }
        if (profileLink != null) {
            profileLink.enable();
        }
    }

    /**
     * May be override
     */
    public void disableUserControl() {
        safeDisableUserControl();
    }

    public void afterUserLogin() {
        if (logoutLink != null) {
            logoutLink.enable();
            logoutLink.show();
        }
        if (profileLink != null) {
            profileLink.enable();
            profileLink.show();
        }
    }

    public void afterUserLogout() {
        if (loginLink != null) {
            loginLink.enable();
            loginLink.show();
        }
        if (registrationLink != null) {
            registrationLink.enable();
            registrationLink.show();
        }
    }

    public abstract void updateAppTitle(@Nullable SafeHtml viewTitle);

}
