package org.jresearch.commons.gwt.app.client.mvc;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.web.bindery.event.shared.Event;

public class FireOnSelect implements ClickHandler {

	private final Bus bus;
	private Event<?> eventToFire;
	private final Object source;

	public FireOnSelect(@Nonnull final Bus bus, final Event<?> eventToFire) {
		this(bus, eventToFire, null);
	}

	public FireOnSelect(@Nonnull final Bus bus, final Event<?> eventToFire, final Object source) {
		this.bus = bus;
		this.eventToFire = eventToFire;
		this.source = source;
	}

	@Override
	public void onClick(final ClickEvent event) {
		if (eventToFire != null) {
			bus.fire(eventToFire, source);
		}
	}

	/**
	 * @param eventToFire
	 *            the eventToFire to set
	 */
	public void setEventToFire(final Event<?> eventToFire) {
		this.eventToFire = eventToFire;
	}

}