package org.jresearch.commons.gwt.app.client.service;

import java.util.List;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.app.shared.model.user.UserModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.app.shared.service.user.UserService;
import org.jresearch.commons.gwt.shared.loader.PageCrudRestLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.PageLoadResultBean;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;

public interface UserRestService extends UserService, DirectRestService {

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_D)
	@Override
	void remove(List<UserModel> model);

	@PUT
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_C)
	@Override
	UserModel create(UserModel prototype);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_U)
	@Override
	void update(UserModel model);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_R)
	@Override
	PageLoadResultBean<UserModel> getAll(PageCrudRestLoadConfigBean<UserModel> config);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CHANGE_PASSWORD1)
	@Override
	void changePassword(String newPassword);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CHANGE_PASSWORD2)
	@Override
	void changePassword(@PathParam("oldPassword") String oldPassword, String newPassword);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_GET_CURRENT_USER)
	@Override
	UserModel getCurrentUser();

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_GET_CURRENT_USER_PROFILE)
	@Override
	UserProfileModel getCurrentUserProfile();

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_GET_PROFILE_TYPES)
	@Override
	List<BusinessTypeModel> getProfileTypes();

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_REMOVE_USER)
	@Override
	void removeUser();

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_UPDATE_PROFILE)
	@Override
	UserProfileModel updateProfile(UserProfileModel profile);

}
