package org.jresearch.commons.gwt.app.client.mvc.event;

import javax.annotation.Nonnull;

import com.google.gwt.event.shared.GwtEvent;

public class AfterLoginEvent extends GwtEvent<AfterLoginHandler> {

	@SuppressWarnings("unused")
	public static final Type<AfterLoginHandler> TYPE = new Type<AfterLoginHandler>();

	@Nonnull
	private final String userId;

	public AfterLoginEvent(@Nonnull String userId) {
		this.userId = userId;
	}

	@Override
	public Type<AfterLoginHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(AfterLoginHandler handler) {
		handler.onAfterLogin(this);
	}

	/**
	 * @return the userId
	 */
	@Nonnull
	public String getUserId() {
		return userId;
	}

}
