package org.jresearch.commons.gwt.app.client.resource;

import javax.annotation.Nonnull;

import com.google.gwt.i18n.client.Messages;
import com.google.gwt.safehtml.shared.SafeHtml;

public interface ComplexText extends Messages {

	@DefaultMessage("_cantRemoveRecord_{0}_")
	String cantRemoveRecord(String name);

	@DefaultMessage("_deleteRecordConfirm_{0}_")
	String deleteRecordConfirm(String record);

	@DefaultMessage("_deleteRecordsConfirm_{0}_")
	String deleteRecordsConfirm(String size);

	@DefaultMessage("_cantUpdateObject_{0}_{1}_")
	String cantUpdateObject(String model, String cause);

	@DefaultMessage("_cantCreateObject_{0}_")
	String cantCreateObject(String cause);

	@DefaultMessage("_someErrorChangingPassword_{0}_")
	String someErrorChangingPassword(String reason);

	@DefaultMessage("_someErrorSaving_{0}_")
	String someErrorSaving(String reason);

	/** Message on update profile */
	@Nonnull
	@DefaultMessage("Your profile was updated successfully.")
	String profileWasUpdated();

	/** Message on logout try in offline mode */
	@Nonnull
	@DefaultMessage("The logout is disable in offline mode")
	String cantLogoutInOfflineMode();

	/** Message on login try in offline mode */
	@Nonnull
	@DefaultMessage("The login is disable in offline mode")
	String cantLoginInOfflineMode();

	/** Login dialog, user name field label */
	@Nonnull
	@DefaultMessage("User name")
	SafeHtml username();

	/** Login dialog, password field label */
	@Nonnull
	@DefaultMessage("Password")
	SafeHtml password();

	/** Reset dialog, email field label */
	@Nonnull
	@DefaultMessage("Email")
	SafeHtml emailField();

}
