package org.jresearch.commons.gwt.app.client.widget;

import java.util.List;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.mvc.event.SignUpEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.LoginEvent;
import org.jresearch.commons.gwt.client.widget.ButtonPanel;
import org.jresearch.commons.gwt.client.widget.FieldDescriptor;
import org.jresearch.commons.gwt.flexess.shared.service.FlexessService.ResetStatus;

import com.google.common.collect.Lists;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

public class ResetPasswordDialog extends AbstractAuthDialog {

	private TextBox email;
	private List<FieldDescriptor<?, ?>> fields;

	public ResetPasswordDialog() {
		super(AppRs.MSG.resetDialog());
	}

	@Override
	protected void createLinks(final ButtonPanel linkBar) {
		linkBar.add(createEventLink(AppRs.MSG.existingUser(), new LoginEvent(), true));
		linkBar.add(signUp = createEventLink(AppRs.MSG.register(), new SignUpEvent(), false));
	}

	@Override
	protected List<FieldDescriptor<?, ?>> getFields() {
		if (fields == null) {
			fields = Lists.newArrayList();

			email = new TextBox();
			fields.add(new FieldDescriptor<>(AppRs.TXT.emailField(), email));
		}

		return fields;
	}

	@Override
	protected String getActionName() {
		return AppRs.MSG.resetAction();
	}

	@Override
	protected void doAction(final Label status) {
		final String value = email.getValue();
		if (value != null) {
			REST.withCallback(new AbstractMethodCallback<ResetStatus>(bus) {
				@SuppressWarnings("incomplete-switch")
				@Override
				public void onSuccess(final Method method, final ResetStatus result) {
					switch (result) {
					case Done:
						ResetPasswordDialog.this.hide();
						if (command != null) {
							Scheduler.get().scheduleDeferred(command);
						}
						break;
					case Disable:
						status.setText(AppRs.MSG.resetNotPossible());
						status.setVisible(true);
						getButtonBar().enable();
						break;
					case NotFound:
						status.setText(AppRs.MSG.emailNotFound());
						status.setVisible(true);
						getButtonBar().enable();
						break;
					}
				}
			}).call(service).reset(value);
		}
	}

	@Override
	protected void resetFields() {
		email.setValue(null);
	}

}
