package org.jresearch.commons.gwt.app.client.widget;

import java.util.ArrayList;
import java.util.List;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.mvc.event.ResetPasswordEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.LoginEvent;
import org.jresearch.commons.gwt.client.widget.ButtonPanel;
import org.jresearch.commons.gwt.client.widget.FieldDescriptor;
import org.jresearch.commons.gwt.flexess.shared.service.FlexessService.SignUpStatus;

import com.google.common.collect.Lists;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

public class SignUpDialog extends AbstractAuthDialog {

	private TextBox email;
	private ArrayList<FieldDescriptor<?, ?>> fields;

	public SignUpDialog() {
		super(AppRs.MSG.registerDialog());
	}

	@Override
	protected void createLinks(final ButtonPanel linkBar) {
		linkBar.add(createEventLink(AppRs.MSG.existingUser(), new LoginEvent(), false));
		linkBar.add(reset = createEventLink(AppRs.MSG.resetPassword(), new ResetPasswordEvent(), false));
	}

	@Override
	protected List<FieldDescriptor<?, ?>> getFields() {
		if (fields == null) {
			fields = Lists.newArrayList();

			email = new TextBox();
			fields.add(new FieldDescriptor<>(AppRs.TXT.emailField(), email));
		}

		return fields;
	}

	@Override
	protected String getActionName() {
		return AppRs.MSG.registerAction();
	}

	@Override
	protected void doAction(final Label status) {
		final String value = email.getValue();
		if (value != null) {
			REST.withCallback(new AbstractMethodCallback<SignUpStatus>(bus) {
				@SuppressWarnings("incomplete-switch")
				@Override
				public void onSuccess(final Method method, final SignUpStatus result) {
					switch (result) {
					case Done:
						SignUpDialog.this.hide();
						if (command != null) {
							Scheduler.get().scheduleDeferred(command);
						}
						break;
					case Disable:
						status.setText(AppRs.MSG.registrationNotPossible());
						status.setVisible(true);
						getButtonBar().enable();
						break;
					case Exist:
						status.setText(AppRs.MSG.userExists());
						status.setVisible(true);
						getButtonBar().enable();
						break;
					}
				}
			}).call(service).signUp(value);
		}
	}

	@Override
	protected void resetFields() {
		email.setValue(null);
	}

}
