package org.jresearch.commons.gwt.app.client.widget.profile;

import javax.annotation.Nonnull;

import org.fusesource.restygwt.client.Method;
import org.jresearch.commons.gwt.app.client.mvc.event.ProfileUpdateEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.INotificator;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class ProfileUpdateCallback extends AbstractMethodCallback<UserProfileModel> {

	@Nonnull
	private final INotificator notificator;

	@Inject
	public ProfileUpdateCallback(@Nonnull final Bus bus, @Nonnull final INotificator notificator) {
		super(bus);
		this.notificator = notificator;
	}

	@Override
	public void onSuccess(final Method method, final UserProfileModel result) {
		notificator.showNotification(AppRs.TXT.profileWasUpdated());
		bus.fire(new ProfileUpdateEvent(result));
	}

}
