package org.jresearch.commons.gwt.app.client.widget;

import java.util.List;

import javax.annotation.Nonnull;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ICommandEvent;
import org.jresearch.commons.gwt.client.widget.ButtonPanel;
import org.jresearch.commons.gwt.client.widget.FieldDescriptor;
import org.jresearch.commons.gwt.client.widget.Uis;
import org.jresearch.commons.gwt.flexess.client.service.FlexessRestService;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;

public abstract class AbstractAuthDialog extends DialogBox implements ICommandWidget<DialogBox> {

    private Button cancel;
    private Button action;
    private Label status;
    protected Command command;
    protected Widget signUp;
    protected Widget reset;
    private boolean initProcessed = false;
    private boolean resetEnable = true;
    private boolean registerEnable = true;

    @Inject
    protected FlexessRestService service;
    @Inject
    @Nonnull
    protected Bus bus;
    private ButtonPanel socialBar;
    private final FlowPanel main;
    private ButtonPanel actionBar;

    protected AbstractAuthDialog(final String heading) {
        main = new FlowPanel();
        setModal(true);
        setText(heading);

        final List<FieldDescriptor<?, ?>> fields = getFields();
        final FlexTable formPanel = new FlexTable();
        for (int i = 0; i < fields.size(); i++) {
            formPanel.setHTML(i, 0, fields.get(i).getLabel());
            formPanel.setWidget(i, 1, fields.get(i).getField());
        }
        main.add(createSocialButtons());
        main.add(formPanel);
        main.add(createLinksButtons());
        main.add(createStatus());
        main.add(createActionButtons());
        setWidget(main);
        addCloseHandler(new CloseHandler<PopupPanel>() {
            @Override
            public void onClose(final CloseEvent<PopupPanel> event) {
                reset();
            }
        });
        setGlassEnabled(true);
    }

    public void setFocus() {
        for (final FieldDescriptor<?, ?> fieldDescriptor : getFields()) {
            final IsWidget field = fieldDescriptor.getField();
            if (field instanceof Focusable) {
                ((Focusable) field).setFocus(true);
                break;
            }
        }
    }

    protected ButtonPanel createActionButtons() {
        actionBar = new ButtonPanel();
        createButtons(actionBar);
        return actionBar;
    }

    protected ButtonPanel createSocialButtons() {
        socialBar = new ButtonPanel();
        createSocialLoginButtons(socialBar);
        return socialBar;
    }

    protected ButtonPanel createLinksButtons() {
        final ButtonPanel linkBar = new ButtonPanel();
        linkBar.addStyleName("j-dialog-link-bar"); //$NON-NLS-1$
        createLinks(linkBar);
        return linkBar;
    }

    protected Label createStatus() {
        if (status == null) {
            status = new Label();
            status.setVisible(false);
        }
        return status;
    }

    @Override
    protected void onAttach() {
        if (resetEnable && reset != null) {
            REST.withCallback(new AbstractMethodCallback<Boolean>(bus) {
                @Override
                public void onSuccess(final Method method, final Boolean response) {
                    reset.setVisible(resetEnable && response != null && response.booleanValue());
                }
            }).call(service).isResetEnable();
        }
        if (registerEnable && signUp != null) {
            REST.withCallback(new AbstractMethodCallback<Boolean>(bus) {
                @Override
                public void onSuccess(final Method method, final Boolean response) {
                    signUp.setVisible(registerEnable && response != null && response.booleanValue());
                }
            }).call(service).isSignUpEnable();
        }
        // due to injection - do not use the injected fields in constructor
        if (!initProcessed) {
            init();
            initProcessed = true;
        }
        super.onAttach();
    }

    abstract protected List<FieldDescriptor<?, ?>> getFields();

    abstract protected String getActionName();

    abstract protected void doAction(Label actionStatus);

    /**
     * some action after all things are injected
     */
    protected void init() {
        // do nothing in base class
    }

    /**
     * @param linkBar
     *            button bar to add the links
     */
    protected void createLinks(final ButtonPanel linkBar) {
        // do nothing in base class
    }

    /**
     * @param bar
     *            button bar to add the social buttons
     */
    protected void createSocialLoginButtons(final ButtonPanel bar) {
        // do nothing in base class
    }

    // @Override
    // protected void onKeyPress(final com.google.gwt.user.client.Event event) {
    // super.onKeyPress(event);
    // final int keyCode = event.getKeyCode();
    // if (keyCode == KeyCodes.KEY_ENTER && action.isEnabled()) {
    // onSubmit();
    // }
    // }

    protected void createButtons(final ButtonPanel panel) {
        panel.clear();
        if (action == null) {
            action = createButton(getActionName(), new ClickHandler() {
                @Override
                public void onClick(final ClickEvent event) {
                    onSubmit();
                }
            });
        }
        panel.add(action);
        if (cancel == null) {
            cancel = createButton(AppRs.MSG.cancelButton(), new ClickHandler() {
                @Override
                public void onClick(final ClickEvent event) {
                    onCancel();
                }
            });
        }
        panel.add(cancel);
    }

    protected void onCancel() {
        hide();
    }

    protected void reset() {
        resetFields();
        status.setText(Uis.NOTHING);
        status.setVisible(false);
        actionBar.enable();
        socialBar.enable();
    }

    protected abstract void resetFields();

    protected void onSubmit() {
        status.setText(AppRs.MSG.pleaseWait());
        status.setVisible(true);
        actionBar.disable();
        socialBar.disable();
        doAction(status);
    }

    protected <E extends Event<?> & ICommandEvent> Widget createEventLink(final String link, final E event, final boolean visible) {
        final Anchor anchor = new Anchor(link);
        anchor.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(final ClickEvent clickEvent) {
                AbstractAuthDialog.this.hide();
                event.setCommand(command);
                bus.fire(event);
            }
        });
        anchor.setVisible(visible);
        return anchor;
    }

    @SuppressWarnings("static-method")
    protected Button createButton(final String text, final ClickHandler onClick) {
        return new Button(text, onClick);
    }

    /**
     * @param command
     *            - command to forward after successful login, <code>null</code>
     *            to skip
     */
    @Override
    public DialogBox setCommand(final Command command) {
        this.command = command;
        return this;
    }

    protected ButtonPanel getSocialBar() {
        return socialBar;
    }

    protected ButtonPanel getButtonBar() {
        return actionBar;
    }

    /**
     * @return the resetEnable
     */
    public boolean isResetEnable() {
        return resetEnable;
    }

    /**
     * @param resetEnable
     *            the resetEnable to set
     */
    public void setResetEnable(final boolean resetEnable) {
        this.resetEnable = resetEnable;
        reset.setVisible(resetEnable);
    }

    /**
     * @return the registerEnable
     */
    public boolean isRegisterEnable() {
        return registerEnable;
    }

    /**
     * @param registerEnable
     *            the registerEnable to set
     */
    public void setRegisterEnable(final boolean registerEnable) {
        this.registerEnable = registerEnable;
        signUp.setVisible(registerEnable);
    }

}
