package org.jresearch.commons.gwt.app.client.gin;

import org.jresearch.commons.gwt.client.gin.InstallableGinModule;
import org.jresearch.commons.gwt.client.gin.UtilsGinModule;
import org.jresearch.commons.gwt.client.model.l18n.L18nDynamicList;
import org.jresearch.commons.gwt.client.widget.DynamicList;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;

public class AppGinModule extends InstallableGinModule {

    private static final String ID = "AppGinModule"; //$NON-NLS-1$

    @Override
    protected void configure() {
        install(new UtilsGinModule());
        //@formatter:off
		bind(new TypeLiteral<DynamicList<LocaleModel>>() {/* bind parameterized class */ }).to(L18nDynamicList.class).in(Singleton.class);
        //@formatter:on
    }

    @Override
    protected String getId() {
        return ID;
    }

}
