package org.jresearch.commons.gwt.app.client.mvc.event;

import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;

import com.google.web.bindery.event.shared.Event;

public class ProfileShowEvent extends Event<ProfileShowHandler> {

	@SuppressWarnings("unused")
	public static final Type<ProfileShowHandler> TYPE = new Type<ProfileShowHandler>();

	private final UserProfileModel userProfileModel;

	public ProfileShowEvent(UserProfileModel userProfileModel) {
		this.userProfileModel = userProfileModel;
	}

	@Override
	public Type<ProfileShowHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ProfileShowHandler handler) {
		handler.onProfileShow(this);
	}

	/**
	 * @return the userProfileModel
	 */
	public UserProfileModel getUserProfileModel() {
		return userProfileModel;
	}

}
