package org.jresearch.commons.gwt.app.client.widget.profile;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.app.shared.model.user.SocialNetworkLoginModel;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.client.mvc.INotificator;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.oauth2.client.mvc.event.SocialAuthenticationEvent;
import org.jresearch.commons.gwt.oauth2.client.widget.SocialAuthenticator;

final public class AddSocialNetworkCommand implements UpdateCommand<SocialAuthenticationEvent> {

	private UserProfileModel profile;
	@Nonnull
	private final SocialAuthenticator authenticator;
	@Nonnull
	private final Bus bus;

	public AddSocialNetworkCommand(@Nonnull final SocialAuthenticator authenticator, @Nonnull final Bus bus) {
		this.authenticator = authenticator;
		this.bus = bus;
	}

	@Override
	public void execute(final SocialAuthenticationEvent event, final INotificator notificator) {
		if (profile != null) {
			authenticator.accociateWithCurrentUser(event.getNetwork(), event.getToken(), new ProfileUpdateCallbackWrapper<Void>(bus, notificator, profile) {
				@Override
				public void onSuccess(final Void result) {
					profile.getUser().getOauthIds().add(new SocialNetworkLoginModel(event.getNetwork(), event.getToken()));
					super.onSuccess(result);
				}
			});
		}
	}

	/**
	 * @param profile
	 *            the profile to set
	 */
	public void setUserProfile(final UserProfileModel profile) {
		this.profile = profile;
	}
}