package org.jresearch.commons.gwt.app.client.widget.profile;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.client.mvc.INotificator;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.gwt.user.client.rpc.AsyncCallback;

public class ProfileUpdateCallbackWrapper<R> implements AsyncCallback<R> {

	private final ProfileUpdateCallback realCallback;
	private UserProfileModel profile;

	public ProfileUpdateCallbackWrapper(@Nonnull final Bus bus, @Nonnull final INotificator notificator) {
		this.realCallback = new ProfileUpdateCallback(bus, notificator);
	}

	public ProfileUpdateCallbackWrapper(@Nonnull final Bus bus, @Nonnull final INotificator notificator, final UserProfileModel profile) {
		this.realCallback = new ProfileUpdateCallback(bus, notificator);
		setProfile(profile);
	}

	@Override
	public void onSuccess(final R result) {
		realCallback.onSuccess(profile);
	}

	@Override
	public void onFailure(final Throwable caught) {
		realCallback.onFailure(caught);
	}

	/**
	 * @param profile
	 *            the profile to set
	 */
	protected void setProfile(final UserProfileModel profile) {
		this.profile = profile;
	}

}
