package org.jresearch.commons.gwt.app.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.app.shared.UsersShared;
import org.jresearch.commons.gwt.app.shared.model.user.UserModel;

import com.google.gwt.safehtml.shared.SafeHtml;

public class Users extends UsersShared {

	protected Users() {
		// prevent instantiation
	}

	/**
	 * @param user
	 *            - user to get name
	 * @return name as {@link SafeHtml} or some default for <code>null</code>
	 *         value
	 */
	@Nonnull
	public static SafeHtml getUserName(@Nullable final UserModel user) {
		return getUserName(user, AppRs.MSG.unknown());
	}

	@Nonnull
	public static SafeHtml getUserPhone(@Nullable final UserModel user) {
		return getUserPhone(user, AppRs.MSG.unknown());
	}

}
