package org.jresearch.commons.gwt.app.client.widget.profile;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.app.client.mvc.event.ProfileUpdateEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.client.mvc.AbstractCallback;
import org.jresearch.commons.gwt.client.mvc.INotificator;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class ProfileUpdateCallback extends AbstractCallback<UserProfileModel> {

	@Nonnull private final INotificator notificator;

	@Inject
	public ProfileUpdateCallback(@Nonnull final Bus bus, @Nonnull final INotificator notificator) {
		super(bus);
		this.notificator = notificator;
	}

	@Override
	public void onSuccess(final UserProfileModel result) {
		notificator.showNotification(AppRs.TXT.profileWasUpdated());
		bus.fire(new ProfileUpdateEvent(result));
	}
}
