package org.jresearch.commons.gwt.app.client.service;

import java.util.Collection;
import java.util.List;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.app.shared.model.user.MailTemplateModel;
import org.jresearch.commons.gwt.app.shared.model.user.SystemEventModel;
import org.jresearch.commons.gwt.app.shared.service.mail.MailTemplateService;
import org.jresearch.commons.gwt.shared.loader.PageCrudLoadConfig;
import org.jresearch.commons.gwt.shared.loader.PageLoadResult;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;

public interface MailTemplateRestService extends MailTemplateService, DirectRestService {

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_D)
	@Override
	void remove(Collection<MailTemplateModel> model);

	@PUT
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_C)
	@Override
	MailTemplateModel create(MailTemplateModel prototype);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_U)
	@Override
	void update(MailTemplateModel model);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_R)
	@Override
	PageLoadResult<MailTemplateModel> getAll(PageCrudLoadConfig<MailTemplateModel> config);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_GET_ALL)
	@Override
	List<MailTemplateModel> getAll();
	
	@GET
	@Path(SRV_ROOT + SRV_PATH + M_GET_EVENTS)
	@Override
	List<SystemEventModel> getEvents();

}
