package org.jresearch.commons.gwt.app.client.mvc.widget;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.widget.Uis;

import com.google.gwt.dom.client.Style.Cursor;
import com.google.gwt.query.client.css.CSS;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HTMLPanel;

public class HtmlPanelUserLink extends HTMLPanel implements UserLink {

    public HtmlPanelUserLink(@Nonnull final String content) {
        super(content);
    }

    public HtmlPanelUserLink(@Nonnull final String cssClass, @Nonnull final SafeHtml content) {
        super(content);
        setStyleName(cssClass);
    }

    @Override
    public void disable() {
        Uis.setStyle(this, CSS.CURSOR.with(Cursor.DEFAULT));
    }

    @SuppressWarnings("null")
    @Override
    public void enable() {
        Uis.setStyle(this, CSS.CURSOR.getCssName(), Uis.NOTHING);
    }

    @Override
    public void show() {
        setVisible(true);
    }

    @Override
    public void hide() {
        setVisible(false);
    }

}
