package org.jresearch.commons.gwt.app.client.mvc.event;

import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;

import com.google.web.bindery.event.shared.Event;

public class ProfileUpdateEvent extends Event<ProfileUpdateHandler> {

	public static Type<ProfileUpdateHandler> TYPE = new Type<>();

	private final UserProfileModel userProfileModel;

	public ProfileUpdateEvent(final UserProfileModel userProfileModel) {
		this.userProfileModel = userProfileModel;
	}

	@Override
	public Type<ProfileUpdateHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final ProfileUpdateHandler handler) {
		handler.onProfileUpdate(this);
	}

	/**
	 * @return the userProfileModel
	 */
	@SuppressWarnings("unchecked")
	public <P extends UserProfileModel> P getUserProfileModel() {
		return (P) userProfileModel;
	}

}
