package org.jresearch.commons.gwt.app.client.widget;

import java.util.List;

import javax.annotation.Nonnull;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.service.AboutRestService;
import org.jresearch.commons.gwt.shared.model.about.AboutModel;

import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.inject.Inject;

public class AboutDialog extends DialogBox {

	@Inject
	public AboutDialog(@Nonnull final AboutRestService srv, final Bus bus) {
		setText(AppRs.MSG.aboutDialog());
		setModal(true);
		// TODO Stas enable hide on esc
		// setOnEsc(true);

		final CellTable<AboutModel> versionTable = new CellTable<>();

		// Initialize the columns.
		initTableColumns(versionTable);

		new AsyncDataProvider<AboutModel>() {
			@Override
			protected void onRangeChanged(final HasData<AboutModel> display) {
				REST.withCallback(new AbstractMethodCallback<List<AboutModel>>(bus) {
					@Override
					public void onSuccess(final Method method, final List<AboutModel> response) {
						if (response != null) {
							versionTable.setRowCount(response.size());
							updateRowData(0, response);
						}
					}
				}).call(srv).getAll();
			}
		}.addDataDisplay(versionTable);

		add(versionTable);
	}

	/**
	 * Add the columns to the table.
	 */
	private static void initTableColumns(final CellTable<AboutModel> versionTable) {
		addColumn(versionTable, AppRs.MSG.module(), 100, new TextColumn<AboutModel>() {
			@Override
			public String getValue(final AboutModel object) {
				return object.getModuleName();
			}
		});
		addColumn(versionTable, AppRs.MSG.version(), 120, new TextColumn<AboutModel>() {
			@Override
			public String getValue(final AboutModel object) {
				return object.getModuleVersion();
			}
		});
		addColumn(versionTable, AppRs.MSG.buildNumber(), 80, new TextColumn<AboutModel>() {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildNum();
			}
		});
		addColumn(versionTable, AppRs.MSG.buildAt(), 100, new TextColumn<AboutModel>() {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildDate();
			}
		});
		addColumn(versionTable, AppRs.MSG.buildOn(), 300, new TextColumn<AboutModel>() {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildServer();
			}
		});
	}

	private static void addColumn(final CellTable<AboutModel> versionTable, final String header, final int pixelWidth, final TextColumn<AboutModel> textColumn) {
		versionTable.addColumn(textColumn, header);
		versionTable.setColumnWidth(textColumn, pixelWidth, Unit.PX);

	}

}
