package org.jresearch.commons.gwt.app.client.mvc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.app.client.mvc.widget.UserLinkContainer;
import org.jresearch.commons.gwt.app.shared.model.user.UserProfileModel;
import org.jresearch.commons.gwt.client.app.AbstractAppView;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.gwt.user.client.Command;

@SuppressWarnings("rawtypes")
public abstract class AbstractUserAppView<C extends AbstractUserAppController> extends AbstractAppView<C> {

    private final UserLinkContainer userLinksContainer;

    public AbstractUserAppView(@Nonnull final C controller, final UserLinkContainer userLinksContainer, @Nonnull final Bus bus) {
        super(controller, bus);
        this.userLinksContainer = userLinksContainer;
    }

    @Nullable
    protected UserLinkContainer getUserLinkContainer() {
        return userLinksContainer;
    }

    abstract public void showSignUpDialod(Command command);

    abstract public void showResetPasswordDialog(Command command);

    /**
     * @param command
     *            - Command to execute on login
     */
    abstract public void showLoginDialog(Command command);

    abstract public void showProfieDialog(UserProfileModel profileModel);

    public void enableUserControls() {
        if (userLinksContainer != null) {
            userLinksContainer.disableUserControl();
            userLinksContainer.afterUserLogin();
        }
    }

    public void disableUserControls() {
        if (userLinksContainer != null) {
            userLinksContainer.disableUserControl();
            userLinksContainer.afterUserLogout();
        }
    }

    public void disableUserControlsAsIs() {
        if (userLinksContainer != null) {
            userLinksContainer.disableUserControlAsIs();
        }
    }

    public void enableUserControlsAsIs() {
        if (userLinksContainer != null) {
            userLinksContainer.enableUserControlAsIs();
        }
    }

    /*
     * (non-Javadoc)
     * @see
     * org.jresearch.commons.gwt.client.app.AbstractAppView#onChangeOfflineMode(
     * boolean)
     */
    @Override
    public void onChangeOfflineMode(final boolean isOffline) {
        super.onChangeOfflineMode(isOffline);
        if (isOffline) {
            disableUserControlsAsIs();
        } else {
            enableUserControlsAsIs();
        }

    }
}
