package org.jresearch.commons.gwt.app.client.widget;

import java.util.ArrayList;
import java.util.List;

import org.jresearch.commons.gwt.client.model.l18n.L18nRenderer;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.SetLanguageEvent;
import org.jresearch.commons.gwt.client.widget.ChosenListBoxBinding;
import org.jresearch.commons.gwt.client.widget.SimpleL18nComboBox;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.model.localization.LocaleTool;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.inject.Inject;

public class LanguageComboBox extends SimpleL18nComboBox {

	@Inject
	public LanguageComboBox(final Bus bus, final ChosenListBoxBinding<LocaleModel> binding, final L18nRenderer renderer) {
		super(binding, renderer);
		if (LocaleInfo.getLocaleCookieName() == null && LocaleInfo.getLocaleQueryParam() == null) {
			// if there is no way for us to affect the locale, don't show the
			// selector
			setEnabled(false);
			setVisible(false);
			return;
		}
		final String[] localeNames = LocaleInfo.getAvailableLocaleNames();
		if (localeNames.length < 2) {
			// if there is only one language don't show the selector
			setEnabled(false);
			setVisible(false);
			return;
		}
		binding.update(getAvailableLocales(binding, localeNames));
		addValueChangeHandler(new ValueChangeHandler<LocaleModel>() {
			@Override
			public void onValueChange(final ValueChangeEvent<LocaleModel> event) {
				bus.fire(new SetLanguageEvent(event.getValue()));
			}
		});
	}

	private static List<? extends LocaleModel> getAvailableLocales(final ChosenListBoxBinding<LocaleModel> binding, final String[] localeNames) {
		final ArrayList<LocaleModel> result = new ArrayList<>();
		String currentLocale = LocaleInfo.getCurrentLocale().getLocaleName();
		if (currentLocale.equals(LocaleModel.DEFAULT_NAME)) {
			currentLocale = LocaleModel.DEFAULT_LANG;
		}
		for (final String localeName : localeNames) {
			if (localeName != LocaleModel.DEFAULT_NAME) {
				final LocaleModel locale = LocaleTool.createLocaleModel(localeName, false);
				locale.setDisplayLanguage(LocaleInfo.getLocaleNativeDisplayName(localeName));
				if (localeName.equals(currentLocale)) {
					binding.setValue(locale);
				}
			}
		}
		return result;
	}
}
