/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.service.about;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jresearch.commons.gwt.client.service.about.IAboutService;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;
import org.jresearch.commons.gwt.shared.model.about.AboutModel;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class AboutService
implements IAboutService {
    public static final String XML_FILE_EXTENSION = ".xml";
    public static final String MODULE_NAME = "module_name";
    public static final String MODULE_VERSION = "module_version";
    public static final String BUILD_NUM = "build_num";
    public static final String BUILD_DATE = "build_date";
    public static final String BUILD_SERVER = "build_at";
    private Resource[] locations;
    private List<AboutModel> infos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        ArrayList<AboutModel> result = new ArrayList<AboutModel>();
        if (this.locations != null) {
            Properties props = new Properties();
            for (Resource location : this.locations) {
                try (InputStream is = location.getInputStream();){
                    if (location.getFilename().endsWith(XML_FILE_EXTENSION)) {
                        props.loadFromXML(is);
                    } else {
                        props.load(is);
                    }
                    result.add(AboutService.createModel(props, location));
                }
                catch (IOException iOException) {
                }
                finally {
                    props.clear();
                }
            }
        }
        this.infos = result;
    }

    public List<AboutModel> getAll(LoadConfig config) {
        return this.infos;
    }

    private static AboutModel createModel(Properties props, Resource location) {
        AboutModel result = new AboutModel();
        result.setBuildDate(props.getProperty(BUILD_DATE, "Undefined"));
        result.setBuildNum(props.getProperty(BUILD_NUM, "Undefined"));
        String property = props.getProperty(MODULE_NAME, "Undefined");
        if (property.equals("${project.name}")) {
            property = location.getDescription();
        }
        result.setModuleName(property);
        result.setModuleVersion(props.getProperty(MODULE_VERSION, "Undefined"));
        result.setBuildServer(props.getProperty(BUILD_SERVER, "Undefined"));
        return result;
    }

    @Required
    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }
}

