/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jresearch.commons.gwt.shared.model.IMappedObject;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.flexess.client.context.IUserContext;
import org.jresearch.flexess.client.context.UserContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DomainAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainAdapter.class);
    @Autowired
    private MapperFacade mapper;
    private final ForkJoinPool oricaPool = new ForkJoinPool(4, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true){

        @Override
        public ForkJoinTask<?> submit(Runnable task) {
            IUserContext context = UserContextManager.getContext();
            return super.submit(() -> {
                try {
                    UserContextManager.setContext((IUserContext)context);
                    task.run();
                }
                finally {
                    UserContextManager.clearContext();
                }
            });
        }
    };

    public ForkJoinPool getPool() {
        return this.oricaPool;
    }

    @Nonnull
    public <S, D> D map(@Nonnull S sourceObject, @Nonnull Class<D> destinationClass) {
        try {
            Object map = this.mapper.map(sourceObject, destinationClass);
            if (IMappedObject.class.isAssignableFrom(destinationClass)) {
                ((IMappedObject)map).setMappedFrom(sourceObject.getClass().getName());
            }
            return (D)map;
        }
        catch (Exception e) {
            String obj = sourceObject.toString();
            try {
                obj = ToStringBuilder.reflectionToString(sourceObject, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
            }
            catch (Error error) {
                // empty catch block
            }
            LOGGER.error("Error while map {} to {}", new Object[]{obj, destinationClass, e});
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public <S, D> Set<D> mapAsSet(@Nonnull Iterable<S> sourceCollection, @Nonnull Class<D> destinationClass) {
        return this.mapAsCollection(sourceCollection, destinationClass, Sets.newHashSet());
    }

    @Nonnull
    public <S, D> List<D> mapAsList(@Nonnull Iterable<S> sourceCollection, @Nonnull Class<D> destinationClass) {
        return this.mapAsCollection(sourceCollection, destinationClass, Lists.newArrayList());
    }

    @Nonnull
    private <S, D, C extends Collection<D>> C mapAsCollection(@Nonnull Iterable<S> sourceCollection, @Nonnull Class<D> destinationClass, @Nonnull C result) {
        try {
            boolean isMappedObject = IMappedObject.class.isAssignableFrom(destinationClass);
            for (S s : sourceCollection) {
                Object map = this.mapper.map(s, destinationClass);
                if (isMappedObject) {
                    ((IMappedObject)map).setMappedFrom(s.getClass().getName());
                }
                result.add((Object)map);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public LocaleModel toGwt(Locale locale, Locale userLocale) {
        LocaleModel result = this.map(locale, LocaleModel.class);
        if (result != null) {
            result.setDisplayLanguage(locale.getDisplayLanguage(userLocale));
            result.setDisplayCountry(locale.getDisplayCountry(userLocale));
            result.setDisplayVariant(locale.getDisplayVariant(userLocale));
        }
        return result;
    }

    public <S extends IMappedObject, D> D reverseMap(@Nonnull S object) {
        try {
            return (D)this.mapper.map(object, Class.forName(object.getMappedFrom()));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Can't load calss {}", (Object)object.getMappedFrom(), (Object)e);
            return null;
        }
    }

    @PreDestroy
    private void shutdown() {
        this.oricaPool.shutdownNow();
    }

    public MapperFacade getMapperFacade() {
        return this.mapper;
    }
}

