/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.rest.about;

import java.util.List;
import java.util.Locale;
import one.util.streamex.StreamEx;
import org.jresearch.commons.gwt.server.service.localization.ILocaleChangeListener;
import org.jresearch.commons.gwt.server.service.localization.LocalizationAdapter;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.service.LocalizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LocalizationServiceController
implements LocalizationService {
    @Autowired
    private List<ILocaleChangeListener> listeners;
    @Autowired
    private LocalizationAdapter adapter;

    @RequestMapping(value={"/l10n/all"}, method={RequestMethod.GET})
    public List<LocaleModel> getLanguages() {
        return ((StreamEx)StreamEx.of((Object[])Locale.getISOLanguages()).map(l -> this.adapter.toGwt(new Locale((String)l))).distinct()).toList();
    }

    @RequestMapping(value={"/l10n/set"}, method={RequestMethod.POST})
    public void setLocale(LocaleModel localeModel) {
        if (!this.listeners.isEmpty()) {
            Locale locale = this.adapter.toDomain(localeModel);
            for (ILocaleChangeListener listener : this.listeners) {
                listener.setLocale(locale);
            }
        }
    }
}

