/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.spring;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class GwtRpcController
extends RemoteServiceServlet
implements Controller,
ServletContextAware {
    private static final String DEFAULT_SERVLET_NAME = "GWT";
    private static final long serialVersionUID = -8608173643144437459L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GwtRpcController.class);
    private ServletContext servletContext;
    private RemoteService remoteService;
    private Class<? extends RemoteService> remoteServiceClass;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.doPost(request, response);
        return null;
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, this.remoteServiceClass, (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse((Object)this.remoteService, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.getServletContext().log("An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected void doUnexpectedFailure(Throwable e) {
        LOGGER.error("Unexpected error", e);
        super.doUnexpectedFailure(e);
    }

    public String getServletName() {
        try {
            String servletName = super.getServletName();
            return servletName == null ? DEFAULT_SERVLET_NAME : servletName;
        }
        catch (NullPointerException e) {
            return DEFAULT_SERVLET_NAME;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setRemoteService(RemoteService remoteService) {
        this.remoteService = remoteService;
        this.remoteServiceClass = this.remoteService.getClass();
    }
}

