/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.web;

import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(value={"*.gwt", "*.html", "*.js", "*.css"})
public class GwtExpiresFilter
implements Filter {
    private static final String NOCACHE = ".nocache.";
    private static final String CACHE = ".cache.";
    private static final String GWT = ".gwt";
    private static final String CSS = ".css";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.contains(NOCACHE) || requestURI.contains(GWT)) {
            Date now = new Date();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setDateHeader("Expires", now.getTime() - 86400000L);
            httpResponse.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setHeader("X-STAS", "true");
        } else if (requestURI.contains(CACHE)) {
            Date now = new Date();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            long secondsToExpire = 315360000L;
            httpResponse.setHeader("Cache-Control", "public,max-age=315360000");
            httpResponse.setDateHeader("Expires", now.getTime() + 315360000000L);
            httpResponse.setHeader("X-STAS", "true");
        } else if (requestURI.contains(CSS)) {
            Date now = new Date();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            long secondsToExpire = 604800L;
            httpResponse.setHeader("Cache-Control", "public,must-revalidate,max-age=604800");
            httpResponse.setDateHeader("Expires", now.getTime() + 604800000L);
            httpResponse.setHeader("X-STAS", "true");
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

