/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.rest.about;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import one.util.streamex.StreamEx;
import org.jresearch.commons.gwt.shared.model.about.AboutModel;
import org.jresearch.commons.gwt.shared.service.AboutService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AboutServiceController
implements AboutService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutServiceController.class);
    public static final String XML_FILE_EXTENSION = ".xml";
    public static final String MODULE_NAME = "module_name";
    public static final String MODULE_VERSION = "module_version";
    public static final String BUILD_NUM = "build_num";
    public static final String BUILD_DATE = "build_date";
    public static final String BUILD_SERVER = "build_at";
    @Value(value="classpath*:conf/about.*")
    private Resource[] locations;
    private List<AboutModel> infos;

    @PostConstruct
    protected void init() {
        this.infos = ((StreamEx)StreamEx.of((Object[])this.locations).nonNull()).map(this::load).flatMap(StreamEx::of).toList();
    }

    @RequestMapping(value={"/about/all"}, method={RequestMethod.GET})
    public List<AboutModel> getAll() {
        return this.infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    private Optional<AboutModel> load(@Nonnull Resource location) {
        Optional<AboutModel> optional;
        Throwable throwable;
        InputStream is;
        Properties props;
        block18: {
            block19: {
                props = new Properties();
                is = location.getInputStream();
                throwable = null;
                if (location.getFilename().endsWith(XML_FILE_EXTENSION)) {
                    props.loadFromXML(is);
                } else {
                    props.load(is);
                }
                optional = Optional.of(AboutServiceController.createModel(props, location));
                if (is == null) break block18;
                if (throwable == null) break block19;
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block18;
            }
            is.close();
        }
        props.clear();
        return optional;
        catch (Throwable throwable3) {
            try {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Something wrong while load about model: {}", (Object)location, (Object)ex);
                    props.clear();
                }
            }
            catch (Throwable throwable6) {
                props.clear();
                throw throwable6;
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private static AboutModel createModel(@Nonnull Properties props, @Nonnull Resource location) {
        AboutModel result = new AboutModel();
        result.setBuildDate(props.getProperty(BUILD_DATE, "Undefined"));
        result.setBuildNum(props.getProperty(BUILD_NUM, "Undefined"));
        String property = props.getProperty(MODULE_NAME, "Undefined");
        if (property.equals("${project.name}")) {
            property = location.getDescription();
        }
        result.setModuleName(property);
        result.setModuleVersion(props.getProperty(MODULE_VERSION, "Undefined"));
        result.setBuildServer(props.getProperty(BUILD_SERVER, "Undefined"));
        return result;
    }
}

