/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.rest.about;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import one.util.streamex.StreamEx;
import org.jresearch.commons.gwt.server.rest.AbstractDomainControler;
import org.jresearch.commons.gwt.server.service.localization.ILocaleChangeListener;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.service.LocalizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LocalizationServiceController
extends AbstractDomainControler
implements LocalizationService {
    @Autowired(required=false)
    private final List<ILocaleChangeListener> listeners = ImmutableList.of();

    @RequestMapping(value={"/l10n/all"}, method={RequestMethod.GET})
    public List<LocaleModel> getLanguages() {
        return ((StreamEx)StreamEx.of((Object[])Locale.getISOLanguages()).map(l -> this.adapter.map(new Locale((String)l), LocaleModel.class)).distinct()).toList();
    }

    @RequestMapping(value={"/l10n/set"}, method={RequestMethod.POST})
    public void setLocale(LocaleModel localeModel) {
        if (localeModel != null && !this.listeners.isEmpty()) {
            Locale locale = this.adapter.map(localeModel, Locale.class);
            this.listeners.forEach(l -> l.setLocale(locale));
        }
    }
}

