/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.service.localization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jresearch.commons.gwt.client.service.localization.ILocalizationService;
import org.jresearch.commons.gwt.server.service.localization.ILocaleChangeListener;
import org.jresearch.commons.gwt.server.service.localization.LocalizationAdapter;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

public class LocalizationService
implements ILocalizationService {
    private final LocalizationAdapter adapter = new LocalizationAdapter();
    private final List<ILocaleChangeListener> listeners = new ArrayList<ILocaleChangeListener>();

    public List<LocaleModel> getLanguages() {
        String[] languages = Locale.getISOLanguages();
        return Stream.of(languages).map(l -> this.adapter.toGwt(new Locale((String)l))).distinct().collect(Collectors.toList());
    }

    public void setLocale(LocaleModel localeModel) {
        if (!this.listeners.isEmpty()) {
            Locale locale = this.adapter.toDomain(localeModel);
            for (ILocaleChangeListener listener : this.listeners) {
                listener.setLocale(locale);
            }
        }
    }

    public void addListener(ILocaleChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILocaleChangeListener listener) {
        this.listeners.remove(listener);
    }
}

