/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.gwt.server.tool;

import javax.annotation.Nonnull;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jresearch.commons.gwt.client.model.time.GwtLocalDateModel;
import org.jresearch.commons.gwt.client.model.time.GwtLocalDateTimeModel;
import org.jresearch.commons.gwt.client.model.time.GwtLocalTimeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class ServerDates {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerDates.class);

    private ServerDates() {
    }

    @Nonnull
    public static LocalDateTime localDateTime(@Nonnull GwtLocalDateTimeModel dateTime) {
        return ServerDates.localDateTime(dateTime.getDate(), dateTime.getTime());
    }

    @Nonnull
    public static GwtLocalDateTimeModel localDateTime(@Nonnull LocalDateTime dateTime) {
        return new GwtLocalDateTimeModel(ServerDates.localDate(dateTime.toLocalDate()), ServerDates.localTime(dateTime.toLocalTime()));
    }

    @Nonnull
    public static LocalDate localDate(@Nonnull GwtLocalDateModel date) {
        return new LocalDate(date.getYear(), date.getMonth(), date.getDay());
    }

    @Nonnull
    public static GwtLocalDateModel localDate(@Nonnull LocalDate date) {
        return new GwtLocalDateModel(date.getDayOfMonth(), date.getMonthOfYear(), date.getYear());
    }

    @Nonnull
    public static LocalTime localTime(@Nonnull GwtLocalTimeModel time) {
        return LocalTime.fromMillisOfDay((long)time.getMiliseconds());
    }

    @Nonnull
    public static GwtLocalTimeModel localTime(@Nonnull LocalTime time) {
        return new GwtLocalTimeModel(time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond());
    }

    @Nonnull
    public static LocalDateTime localDateTime(@Nonnull GwtLocalDateModel date, @Nonnull GwtLocalTimeModel time) {
        return ServerDates.localDate(date).toLocalDateTime(ServerDates.localTime(time));
    }

    public static DurationFieldType duration(int timeUnit) {
        switch (timeUnit) {
            case 0: {
                return DurationFieldType.eras();
            }
            case 1: {
                return DurationFieldType.years();
            }
            case 2: {
                return DurationFieldType.months();
            }
            case 3: 
            case 4: {
                return DurationFieldType.weeks();
            }
            case 5: 
            case 6: {
                return DurationFieldType.days();
            }
            case 10: 
            case 11: {
                return DurationFieldType.hours();
            }
            case 12: {
                return DurationFieldType.minutes();
            }
            case 13: {
                return DurationFieldType.seconds();
            }
            case 14: {
                return DurationFieldType.millis();
            }
        }
        FormattingTuple tuple = MessageFormatter.format((String)"Can't resolve the duration unit: {}", (Object)timeUnit);
        IllegalStateException e = new IllegalStateException(tuple.getMessage());
        LOGGER.error(tuple.getMessage(), (Throwable)e);
        throw e;
    }
}

