package org.jresearch.commons.gwt.client.base.resource;

import javax.annotation.Nonnull;

import com.google.gwt.i18n.client.Messages;

public interface FormatText extends Messages {

	@Nonnull
	@DefaultMessage("Error: {0}")
	String error(Throwable data);

	@Nonnull
	@DefaultMessage("{0} ({1})")
	String printWeek(Integer week, String year);

	@Nonnull
	@DefaultMessage("{0}-{1} {2} {3}")
	String rangeSameMonthWithYear(int startDay, int endDay, String month, int year);

	@Nonnull
	@DefaultMessage("{0}-{1} {2}")
	String rangeSameMonth(int startDay, int endDay, String month);

	@Nonnull
	@DefaultMessage("{0} - {1} {2}")
	String rangeWithYear(String dateStart, String dateEnd, int year);

	@Nonnull
	@DefaultMessage("{0} - {1}")
	String range(String dateStart, String dateEnd);

	@Nonnull
	@DefaultMessage("{0}-{1} {2}")
	String range(String dateStart, String dateEnd, String dayOfMonth);

	@Nonnull
	@DefaultMessage("/{0}")
	String page(String moduleId);

	@Nonnull
	@DefaultMessage("Ask to fire event {0}")
	String logFire(String event);

	@Nonnull
	@DefaultMessage("Fire event {0}")
	String logFireIm(String event);

	@Nonnull
	@DefaultMessage("Scroll possition is {0}")
	String logScroll(int possition);

}
