package org.jresearch.commons.gwt.client.service.localization;

import java.util.List;

import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("localizationService.gwt")
public interface ILocalizationService extends RemoteService {

	String ID = "LocalizationService_SERVICE"; //$NON-NLS-1$
	String STORE = "LocalizationService_STORE"; //$NON-NLS-1$

	List<LocaleModel> getLanguages();

	/**
	 * Server callback to report to server locale changes on client side
	 *
	 * @param locale
	 *            - new client locale
	 */
	void setLocale(LocaleModel locale);

}