package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.app.AbstractAppController;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.module.ModuleEvent;
import org.jresearch.commons.gwt.client.mvc.event.module.ModuleHandler;

import com.google.gwt.inject.client.AsyncProvider;
import com.google.inject.Singleton;

@Singleton
@SuppressWarnings("rawtypes")
public class AbstractModuleController<V extends AbstractView> extends AbstractController<V> implements ModuleHandler {

	@Nonnull private final AbstractAppController appController;
	private boolean active = false;

	public AbstractModuleController(@Nonnull final String id, @Nonnull final Bus bus, @Nonnull final AbstractAppController appController, @Nonnull final AsyncProvider<V> view) {
		super(id, bus, view);
		this.appController = appController;
		bus.addHandler(ModuleEvent.TYPE, this);
	}

	@Override
	public String getModuleId() {
		return ModuleEvent.ANY_ID;
	}

	@SuppressWarnings("unchecked")
	@Override
	public AbstractAppController getParentController() {
		return appController;
	}

	@Override
	public void onModule(final ModuleEvent event) {
		if (event.getModuleId().equals(getId())) {
			if (!active) {
				active = true;
				onModileActivation(event);
			}
		} else {
			if (active) {
				active = false;
				onModileDeactivation(event);
			}
		}
	}

	/**
	 * calls on switch to this module
	 *
	 * @param event
	 */
	public void onModileActivation(final ModuleEvent event) {
		showView();
	}

	/**
	 * calls on switch to another module
	 *
	 * @param event
	 */
	public void onModileDeactivation(final ModuleEvent event) {
		// do nothing
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

}
