package org.jresearch.commons.gwt.client.tool;

import com.google.gwt.user.client.Timer;

/**
 * Deferred task that defers it execution on each update
 */
public class GwtDeferredTask {

	private final Timer timer;

	public GwtDeferredTask(Runnable task) {
		timer = new Timer() {
			@Override
			public void run() {
				task.run();
			}
		};
	}

	/** Cancels the task */
	public void cancel() {
		timer.cancel();
	}

	/**
	 * Resets the timer if any and starts the new one with specified delay.
	 *
	 * @param delay
	 *            - the delay in milliseconds, 0 to run immediately
	 */
	public void defer(final int delay) {
		timer.cancel();
		if (delay > 0) {
			timer.schedule(delay);
		} else {
			timer.run();
		}
	}

}
