package org.jresearch.commons.gwt.client.app;

import java.io.Serializable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.client.base.resource.BaseRs;
import org.jresearch.commons.gwt.client.widget.Uis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gwt.resources.client.ImageResource;

public class GeneralModule implements IAppModule, Serializable {

    private static final long serialVersionUID = 899032954650462280L;

    @Nonnull
    private final String group;
    @Nonnull
    private final String name;
    @Nonnull
    private final String moduleId;
    @Nonnull
    private String moduleDescription = Uis.NOTHING;
    @Nullable
    private ImageResource icon = null;
    private final boolean supportOffline;

    public GeneralModule(@Nonnull final String moduleId) {
        this(moduleId, moduleId, moduleId);
    }

    public GeneralModule(@Nonnull final String name, @Nonnull final String group, @Nonnull final String moduleId) {
        this.name = name;
        this.group = group;
        this.moduleId = moduleId;
        supportOffline = false;
    }

    @Nonnull
    @Override
    public String getModuleId() {
        return moduleId;
    }

    @Nonnull
    @Override
    public String getName() {
        return name;
    }

    /**
     * @return the moduleDescription
     */
    @Override
    public String getDescription() {
        return moduleDescription.isEmpty() ? BaseRs.TXT.noDescription() : moduleDescription;
    }

    /**
     * @param moduleDescription
     *            the moduleDescription to set
     */
    public void setModuleDescription(@Nonnull final String moduleDescription) {
        this.moduleDescription = moduleDescription;
    }

    /**
     * @return the icon
     */
    @Override
    public ImageResource getIcon() {
        return icon;
    }

    /**
     * @param icon
     *            the icon to set
     */
    public void setIcon(@Nullable final ImageResource icon) {
        this.icon = icon;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("name", name) //$NON-NLS-1$
                .add("moduleId", moduleId) //$NON-NLS-1$
                .add("moduleDescription", moduleDescription) //$NON-NLS-1$
                .add("icon", icon) //$NON-NLS-1$
                .toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(getModuleId());
    }

    @Override
    public boolean equals(final Object object) {
        if (object instanceof GeneralModule) {
            final GeneralModule that = (GeneralModule) object;
            return Objects.equal(this.getModuleId(), that.getModuleId());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * @see org.jresearch.commons.gwt.client.app.IAppModule#supportsOffline()
     */
    @Override
    public boolean supportsOffline() {
        return supportOffline;
    }

    /**
     * @return the group
     */
    @Override
    public String getGroup() {
        return group;
    }

}
