package org.jresearch.commons.gwt.client;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.event.Bus;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public abstract class AbstractModule {

	protected final Bus bus;

	public AbstractModule(@Nonnull final Bus bus) {
		this.bus = bus;
	}

	public void start() {
		startUp();
	}

	@SuppressWarnings("static-method")
	protected void startUp() {
		// disable ask toolbar
		removeAsk();
	}

	private static native void removeAsk() /*-{
		if (document.getElementById("apn-null-toolbar") != null) {
			// mainMenu had a style change for its top positioning, returning it to normal
			// perhaps a function can be made which iterates over every element ask has changed
			document.getElementById("mainMenu").style.top = "-16px";
			// Just remove the iframe and style elements
			(elem = document.getElementById("apn-null-toolbar")).parentNode
					.removeChild(elem);
			(elem = document.getElementById("apn-body-style")).parentNode
					.removeChild(elem);
		}
	}-*/;

}
